(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    219647,       3864]
NotebookOptionsPosition[    217635,       3795]
NotebookOutlinePosition[    218056,       3811]
CellTagsIndexPosition[    218013,       3808]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["03 Surfaces Lab ", "Section",
 CellChangeTimes->{{3.54447434392649*^9, 3.5444743478337135`*^9}, {
   3.5444778393684177`*^9, 3.544477849064973*^9}, 3.5444800126867247`*^9}],

Cell["\<\
The goal of this lab is to produce graphs that help us visualize mathematical \
concept or are simply beautiful.\
\>", "Text",
 CellChangeTimes->{{3.5444800658527656`*^9, 3.5444801505576105`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Some Useful ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Commands"
}], "Subsection",
 CellChangeTimes->{{3.544476127231489*^9, 3.544476143964446*^9}}],

Cell["\<\
Define functions that can create axes and points with locator dashed line \
segments. \
\>", "Text",
 CellChangeTimes->{{3.544474378453465*^9, 3.5444743795975304`*^9}, {
  3.54447579767664*^9, 3.544475842558207*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", "p"}]}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.544474480101279*^9}],

Cell["\<\
Graph (1) an orange x-axis from -5 to 5, (2) a dark yellow y-axis from -5 to \
5, (3) a green z-axis from -5 to 5, (4) a black point with locator dashed \
line segments, (5) a blue arrow, (6) a thick magenta line segment, (7) a \
brown polygon with 60% opacity, and (8) a brown large point with 60% opacity. \
Include axes scale labels on the edges of the bounding box and place the view \
point at a point corresponding to what we have done by hand.\
\>", "Text",
 CellChangeTimes->{{3.5444754131296453`*^9, 3.5444755919748745`*^9}, {
  3.5444756233376684`*^9, 3.5444756299640474`*^9}, {3.5444756600357676`*^9, 
  3.544475783670839*^9}, {3.5444760190193*^9, 3.5444760413015747`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "Black", ",", 
        "\"\<a\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "5"}], ",", 
             RowBox[{"-", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", "Thick", ",", 
        "Magenta", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "5"}], ",", "5", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", 
             RowBox[{"-", "5"}], ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Opacity", "[", 
         RowBox[{".6", ",", "Brown"}], "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "5", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "5", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5443610784474154`*^9, 3.5443611362401943`*^9}, {
   3.5443613949800653`*^9, 3.544361396563224*^9}, {3.5443614885004168`*^9, 
   3.544361605875153*^9}, {3.544361852158779*^9, 3.544361872019765*^9}, {
   3.544361953787941*^9, 3.5443620448600473`*^9}, {3.544362166049165*^9, 
   3.5443622084204016`*^9}, {3.5443640531058517`*^9, 
   3.5443640561951604`*^9}, {3.5443669177612886`*^9, 3.54436692477199*^9}, {
   3.544366955665078*^9, 3.544366961128625*^9}, {3.544377637197*^9, 
   3.544377638352*^9}, {3.5443950683415627`*^9, 3.544395068606578*^9}, {
   3.5444510717038016`*^9, 3.5444510845619917`*^9}, {3.5444511552365685`*^9, 
   3.544451159777071*^9}, {3.5444512108626204`*^9, 3.544451225139457*^9}, {
   3.5444512632266245`*^9, 3.5444512802350035`*^9}, 3.5444513909127927`*^9, 
   3.5444514533256063`*^9, {3.5444514921290236`*^9, 3.5444515050322914`*^9}, 
   3.5444532827768297`*^9, {3.544474474630966*^9, 3.544474704472112*^9}, {
   3.5444747654315987`*^9, 3.54447487472285*^9}, {3.5444749079337497`*^9, 
   3.5444749272718554`*^9}, {3.5444750805466223`*^9, 3.544475092063281*^9}, {
   3.544475132828613*^9, 3.544475162139289*^9}, {3.5444751999704533`*^9, 
   3.544475237978627*^9}, {3.544475271036518*^9, 3.544475285520346*^9}, {
   3.544475332661042*^9, 3.5444753376333265`*^9}, {3.544475376706562*^9, 
   3.5444753855250664`*^9}, {3.5444756468350124`*^9, 3.544475647444047*^9}, {
   3.5444758926250706`*^9, 3.5444759292131634`*^9}, {3.5444759684864097`*^9, 
   3.5444759906336765`*^9}, {3.544476076767603*^9, 3.5444760907124004`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-5, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 5.25, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox["\<\"z\"\>", {0., 0., 5.25}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -5}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{Small, Small}], 
         Line3DBox[{{1, 0, 0}, {1, 2, 0}, {1, 2, 3}}], 
         {PointSize[Medium], Point3DBox[{1, 2, 3}], 
          {Dashing[{}], 
           Text3DBox["\<\"a\"\>", {1.1, 2.2, 3.3000000000000003`}], 
           {RGBColor[0, 0, 1], Arrow3DBox[{{1, -5, -2}, {1, -1, -2}}]}, 
           {RGBColor[1, 0, 1], Thickness[Large], 
            Line3DBox[{{-5, 5, 5}, {5, -5, 4}}], 
            {RGBColor[0.6, 0.4, 0.2], Opacity[0.6], 
             Polygon3DBox[{{0, 0, 0}, {0, 0, 4}, {0, 5, 4}, {0, 5, 0}}], 
             {PointSize[Large], Point3DBox[{4, 0, 0}]}}}}}}}}}}}},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{3.5764965591864667`*^9}]
}, Open  ]],

Cell[TextData[{
 "Graph the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"x", "-", "y", "-", "4"}]}], TraditionalForm]]],
 " on the domain ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], ":", 
      RowBox[{
       RowBox[{"-", "5"}], "\[LessEqual]", "x", "\[LessEqual]", "5"}]}], ",", 
     RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", "5"}]}], "}"}], 
   TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5444763614648867`*^9, 3.5444764384872923`*^9}, {
  3.5444769118213654`*^9, 3.544476937481833*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"x", "-", "y", "-", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5444761814615912`*^9, 3.5444762035428543`*^9}, {
  3.5444762671164904`*^9, 3.544476321387594*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9nXeYVNX9/2cLyy6wy7JLR2kOXYoYMVFxRoPKWGKCiiaIoGINg4VmiYL0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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmWnAV0Mbxs+cmSdCJakoJEVppV0qtBJZylqIUKHFVvZ9TYu1bBFaSEVE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         "]], Polygon3DBox[CompressedData["
1:eJwtmnXgVEUXhndm9oeIjaKA0mAQIja2YHeLDYod2IXdhZ1YYCsWYIGJgWJ3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         "]], Polygon3DBox[CompressedData["
1:eJwt2HfcjXUfB/DjnPuQmRAqpKzMlJm9yc4uq8yGkayGURml0FChgZLW03oe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         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0rsrhWEcwPGX485xSVaykIFRBkYZmCQDGxkYKBkYDWKz8RewktgVm/v9
fkuS2+J+jc9Thu/7+b2dp87v6Zzitp7G7oQoiob0qjA/6lIziVGUy3kWcY0V
PGUNH9jAb7YyKxZFcXWZyzjAKo6wjuNs5iQ7OMc+LvKF13zXlp51ryULbXOZ
O1zhLle5F3biPtd5wA0ecpNbOjJv85g7POEuT7nHM+7znFPuccMPXYSdwh01
ardNDnKBvZxlOyfYxDHWcpiV7GcpS9RpTmcLP31HPe9YzWOWh3uxkE/OXfFN
OeE9nFWBHbOZzzjzmBXOMJNxZjCT6UxjqtLMyWFmjCnhN2Yyf5Wkn/CZvmSN
aNrj9v//8AfXm0sB
       "]]}, {
      Line3DBox[{690, 1010, 1015, 1352, 689, 1128, 912, 691, 1129, 913, 692, 
       1130, 914, 693, 1131, 915, 694, 1132, 916, 695, 1133, 917, 696, 1134, 
       1016, 1241, 697, 1135, 918, 698, 1136, 919, 699, 1137, 920, 700, 1138, 
       921, 701, 1139, 922, 702, 1125, 1140, 923, 1011}], 
      Line3DBox[{704, 1017, 1242, 703, 1018, 1243, 705, 1141, 924, 706, 1142, 
       925, 707, 1143, 926, 708, 1144, 927, 709, 1145, 928, 710, 1146, 1019, 
       1244, 711, 1020, 1245, 712, 1147, 929, 713, 1148, 930, 714, 1149, 931, 
       715, 1150, 932, 716, 1151, 933, 717}], 
      Line3DBox[{719, 1021, 1246, 718, 1022, 1247, 720, 1023, 1248, 721, 1152,
        934, 722, 1153, 935, 723, 1154, 936, 724, 1155, 937, 725, 1156, 1024, 
       1249, 726, 1025, 1250, 727, 1026, 1251, 728, 1157, 938, 729, 1158, 939,
        730, 1159, 940, 731, 1160, 941, 732}], 
      Line3DBox[{734, 1027, 1252, 733, 1028, 1253, 735, 1029, 1254, 736, 1030,
        1255, 737, 1161, 942, 738, 1162, 943, 739, 1163, 944, 740, 1164, 1031,
        1256, 741, 1032, 1257, 742, 1033, 1258, 743, 1034, 1259, 744, 1165, 
       945, 745, 1166, 946, 746, 1167, 947, 747}], 
      Line3DBox[{749, 1035, 1260, 748, 1036, 1261, 750, 1037, 1262, 751, 1038,
        1263, 752, 1039, 1264, 753, 1168, 948, 754, 1169, 949, 755, 1170, 
       1040, 1265, 756, 1041, 1266, 757, 1042, 1267, 758, 1043, 1268, 759, 
       1044, 1269, 760, 1171, 950, 761, 1172, 951, 762}], 
      Line3DBox[{764, 1045, 1270, 763, 1046, 1271, 765, 1047, 1272, 766, 1048,
        1273, 767, 1049, 1274, 768, 1050, 1275, 769, 1173, 952, 770, 1174, 
       1051, 1276, 771, 1052, 1277, 772, 1053, 1278, 773, 1054, 1279, 774, 
       1055, 1280, 775, 1056, 1281, 776, 1175, 953, 777}], 
      Line3DBox[{781, 1176, 954, 779, 1177, 955, 783, 1178, 956, 785, 1179, 
       957, 787, 1180, 958, 789, 1181, 959, 791, 1182, 960, 793, 1184, 1185, 
       961, 795, 1186, 962, 797, 1187, 963, 799, 1188, 964, 801, 1189, 965, 
       803, 1190, 966, 805, 1191, 967, 807}], 
      Line3DBox[{806, 1295, 1070, 804, 1294, 1069, 802, 1293, 1068, 800, 1292,
        1067, 798, 1291, 1066, 796, 1290, 1065, 794, 1289, 1064, 1183, 792, 
       1288, 1063, 790, 1287, 1062, 788, 1286, 1061, 786, 1285, 1060, 784, 
       1284, 1059, 782, 1283, 1058, 778, 1282, 1057, 780}], 
      Line3DBox[{809, 1071, 1296, 808, 1192, 968, 810, 1193, 969, 811, 1194, 
       970, 812, 1195, 971, 813, 1196, 972, 814, 1197, 973, 815, 1198, 1072, 
       1297, 816, 1199, 974, 817, 1200, 975, 818, 1201, 976, 819, 1202, 977, 
       820, 1203, 978, 821, 1204, 979, 822}], 
      Line3DBox[{824, 1073, 1298, 823, 1074, 1299, 825, 1205, 980, 826, 1206, 
       981, 827, 1207, 982, 828, 1208, 983, 829, 1209, 984, 830, 1210, 1075, 
       1300, 831, 1076, 1301, 832, 1211, 985, 833, 1212, 986, 834, 1213, 987, 
       835, 1214, 988, 836, 1215, 989, 837}], 
      Line3DBox[{839, 1077, 1302, 838, 1078, 1303, 840, 1079, 1304, 841, 1216,
        990, 842, 1217, 991, 843, 1218, 992, 844, 1219, 993, 845, 1220, 1080, 
       1305, 846, 1081, 1306, 847, 1082, 1307, 848, 1221, 994, 849, 1222, 995,
        850, 1223, 996, 851, 1224, 997, 852}], 
      Line3DBox[{854, 1083, 1308, 853, 1084, 1309, 855, 1085, 1310, 856, 1086,
        1311, 857, 1225, 998, 858, 1226, 999, 859, 1227, 1000, 860, 1228, 
       1087, 1312, 861, 1088, 1313, 862, 1089, 1314, 863, 1090, 1315, 864, 
       1229, 1001, 865, 1230, 1002, 866, 1231, 1003, 867}], 
      Line3DBox[{869, 1091, 1316, 868, 1092, 1317, 870, 1093, 1318, 871, 1094,
        1319, 872, 1095, 1320, 873, 1232, 1004, 874, 1233, 1005, 875, 1234, 
       1096, 1321, 876, 1097, 1322, 877, 1098, 1323, 878, 1099, 1324, 879, 
       1100, 1325, 880, 1235, 1006, 881, 1236, 1007, 882}], 
      Line3DBox[{884, 1101, 1326, 883, 1102, 1327, 885, 1103, 1328, 886, 1104,
        1329, 887, 1105, 1330, 888, 1106, 1331, 889, 1237, 1008, 890, 1238, 
       1107, 1332, 891, 1108, 1333, 892, 1109, 1334, 893, 1110, 1335, 894, 
       1111, 1336, 895, 1112, 1337, 896, 1239, 1009, 897}], 
      Line3DBox[{911, 1014, 1351, 1127, 910, 1350, 1124, 909, 1349, 1123, 908,
        1348, 1122, 907, 1347, 1121, 906, 1346, 1120, 905, 1345, 1119, 1240, 
       904, 1344, 1118, 903, 1343, 1117, 902, 1342, 1116, 901, 1341, 1115, 
       900, 1340, 1114, 899, 1339, 1113, 898, 1126, 1338, 1012, 1013}]}, {
      Line3DBox[{251, 474, 1128, 252, 1243, 488, 280, 1247, 503, 295, 1253, 
       518, 310, 1261, 533, 325, 1271, 548, 340, 1283, 563, 1177, 355, 578, 
       1192, 370, 1299, 593, 385, 1303, 608, 400, 1309, 623, 415, 1317, 638, 
       430, 1327, 653, 445, 1339, 668, 460}], 
      Line3DBox[{253, 475, 1129, 254, 489, 1141, 281, 1248, 504, 296, 1254, 
       519, 311, 1262, 534, 326, 1272, 549, 341, 1284, 564, 1178, 356, 579, 
       1193, 371, 594, 1205, 386, 1304, 609, 401, 1310, 624, 416, 1318, 639, 
       431, 1328, 654, 446, 1340, 669, 461}], 
      Line3DBox[{255, 476, 1130, 256, 490, 1142, 282, 505, 1152, 297, 1255, 
       520, 312, 1263, 535, 327, 1273, 550, 342, 1285, 565, 1179, 357, 580, 
       1194, 372, 595, 1206, 387, 610, 1216, 402, 1311, 625, 417, 1319, 640, 
       432, 1329, 655, 447, 1341, 670, 462}], 
      Line3DBox[{257, 477, 1131, 258, 491, 1143, 283, 506, 1153, 298, 521, 
       1161, 313, 1264, 536, 328, 1274, 551, 343, 1286, 566, 1180, 358, 581, 
       1195, 373, 596, 1207, 388, 611, 1217, 403, 626, 1225, 418, 1320, 641, 
       433, 1330, 656, 448, 1342, 671, 463}], 
      Line3DBox[{259, 478, 1132, 260, 492, 1144, 284, 507, 1154, 299, 522, 
       1162, 314, 537, 1168, 329, 1275, 552, 344, 1287, 567, 1181, 359, 582, 
       1196, 374, 597, 1208, 389, 612, 1218, 404, 627, 1226, 419, 642, 1232, 
       434, 1331, 657, 449, 1343, 672, 464}], 
      Line3DBox[{261, 479, 1133, 262, 493, 1145, 285, 508, 1155, 300, 523, 
       1163, 315, 538, 1169, 330, 553, 1173, 345, 1288, 568, 1182, 360, 583, 
       1197, 375, 598, 1209, 390, 613, 1219, 405, 628, 1227, 420, 643, 1233, 
       435, 658, 1237, 450, 1344, 673, 465}], 
      Line3DBox[{263, 480, 1134, 265, 494, 1146, 286, 509, 1156, 301, 524, 
       1164, 316, 539, 1170, 331, 554, 1174, 346, 569, 1183, 1184, 361, 584, 
       1198, 376, 599, 1210, 391, 614, 1220, 406, 629, 1228, 421, 644, 1234, 
       436, 659, 1238, 451, 674, 1240, 466}], 
      Line3DBox[{267, 482, 1135, 268, 1245, 496, 288, 1250, 511, 303, 1257, 
       526, 318, 1266, 541, 333, 1277, 556, 348, 1290, 571, 1186, 363, 586, 
       1199, 378, 1301, 601, 393, 1306, 616, 408, 1313, 631, 423, 1322, 646, 
       438, 1333, 661, 453, 1346, 676, 468}], 
      Line3DBox[{269, 483, 1136, 270, 497, 1147, 289, 1251, 512, 304, 1258, 
       527, 319, 1267, 542, 334, 1278, 557, 349, 1291, 572, 1187, 364, 587, 
       1200, 379, 602, 1211, 394, 1307, 617, 409, 1314, 632, 424, 1323, 647, 
       439, 1334, 662, 454, 1347, 677, 469}], 
      Line3DBox[{271, 484, 1137, 272, 498, 1148, 290, 513, 1157, 305, 1259, 
       528, 320, 1268, 543, 335, 1279, 558, 350, 1292, 573, 1188, 365, 588, 
       1201, 380, 603, 1212, 395, 618, 1221, 410, 1315, 633, 425, 1324, 648, 
       440, 1335, 663, 455, 1348, 678, 470}], 
      Line3DBox[{273, 485, 1138, 274, 499, 1149, 291, 514, 1158, 306, 529, 
       1165, 321, 1269, 544, 336, 1280, 559, 351, 1293, 574, 1189, 366, 589, 
       1202, 381, 604, 1213, 396, 619, 1222, 411, 634, 1229, 426, 1325, 649, 
       441, 1336, 664, 456, 1349, 679, 471}], 
      Line3DBox[{275, 486, 1139, 276, 500, 1150, 292, 515, 1159, 307, 530, 
       1166, 322, 545, 1171, 337, 1281, 560, 352, 1294, 575, 1190, 367, 590, 
       1203, 382, 605, 1214, 397, 620, 1223, 412, 635, 1230, 427, 650, 1235, 
       442, 1337, 665, 457, 1350, 680, 472}], 
      Line3DBox[{277, 682, 683, 1140, 278, 501, 1151, 293, 516, 1160, 308, 
       531, 1167, 323, 546, 1172, 338, 561, 1175, 353, 1295, 576, 1191, 368, 
       591, 1204, 383, 606, 1215, 398, 621, 1224, 413, 636, 1231, 428, 651, 
       1236, 443, 666, 1239, 458, 1351, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1338, 444, 652, 1326, 429, 637, 1316, 414, 
       622, 1308, 399, 607, 1302, 384, 592, 1298, 369, 577, 1296, 354, 1176, 
       562, 1282, 339, 547, 1270, 324, 532, 1260, 309, 517, 1252, 294, 502, 
       1246, 279, 487, 1242, 250, 473, 1352, 681, 688}], 
      Line3DBox[{467, 675, 1345, 452, 660, 1332, 437, 645, 1321, 422, 630, 
       1312, 407, 615, 1305, 392, 600, 1300, 377, 585, 1297, 362, 1185, 570, 
       1289, 347, 555, 1276, 332, 540, 1265, 317, 525, 1256, 302, 510, 1249, 
       287, 495, 1244, 266, 481, 1241, 264}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJztyLENQFAABcAXYgyFGQzwK4naCBK12ha2MIZdTEKhsoHkqkuum9dpqZKM
TVI/tv0+HNt1vpaP3nvvvffee++9995777333nvvvffee++9995777333nvv
vffee++9995777333nvvvffee++9995777333nvvvffee++9995777333nvv
f/I3uj+BVA==
    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-5, 5}, {0, 5}, {-13.99999892857143, 0.9999989285714284}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5764965605593987`*^9}]
}, Open  ]],

Cell[TextData[{
 "Graph ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "-", "y", "-", "z"}], "=", "4"}], TraditionalForm]]],
 " inside the bounding box ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
      RowBox[{
       RowBox[{"-", "5"}], "\[LessEqual]", "x", "\[LessEqual]", "5"}]}], ",", 
     RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", "5"}], ",", 
     RowBox[{
      RowBox[{"-", "14"}], "\[LessEqual]", "z", "\[LessEqual]", "1"}]}], 
    "}"}], TraditionalForm]]],
 ".  This is the same set of points as in the previous command although the \
rendering is somewhat different."
}], "Text",
 CellChangeTimes->{{3.5444768081864376`*^9, 3.544476899033634*^9}, {
  3.544476961067182*^9, 3.5444770071668186`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "14"}], ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544476468120987*^9, 3.5444765125385275`*^9}, {
  3.544476580643423*^9, 3.544476661296036*^9}, {3.54447673793742*^9, 
  3.5444767550814004`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1vXVUVdH2/n0OB5AQJBQRQWkbUbEwSFtBTCywA0VRFBWk0+4ORGyxxUTZ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   "], {{
     {GrayLevel[1], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt13vcz+UZB/Df8/ye3/NIsclhRUSIjZzKIedDqjlsaEkSKTmkEQ0xGh1I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         "]], Polygon3DBox[CompressedData["
1:eJxN3Hf8h1P5P/D3+txvQmZGyN6jQmRlEzIie2QUGSErVGRkNmwhZRNZ2aOs
jGQmJNs3K7tSKPV7PV2nx+P3x/l8znWfc5/3Pc64rtfrde45ttt9g90GvV7v
KxO93ij/Z+t6vWXy/0s5OM2417th2OttHHvT2MukzgKp9FrsF/u93uPJX5B0
afJLp959Kf9F/q+W8k1Sf+nYy+f/1LEnS1o5+UtT/4TUXzD17k353EkTOf6N
2P9K/s2Un5vyxWO/F/v69vuuZ8nYF+T6Lkj5P1Lvz7m+c1O+dMo3TvlSKX8g
5VMlP2XSg8k/l3rvpf4+qfcf5+f/Cqn/hZQvHvuy2J+P/cXYn439iHZTf5Mc
fzn21Wnj88n/MfnJJun1Xkn5oF3v+zn20/z/VM5fPcc+GfsPKX8m52+c4y/F
niHnfyLly6Z8slzvn1P+75TvnPJ3U/772E/G/lLsF2OvEHvq2E8kPZT8PTm/
G9Qz+l3y7+fYpMnvlfofpP6J+T9r2l81xxaZqDrqeq5T5np/nfp3pq3VU+/R
HLs89tWxP5q0bPKX5/gXcv66OWeJlH8y53889laxp831Lpk6k6Xu7Uk3JX9V
yu9Jfo2ct1zKb8z/zVN/s9RfLudfkzo3p3yFHH849kKpv0HKN9APUv+XKb82
5cul/EHPN/YNsT8X+/exF039LVJ3+eS/lfpXpvy6lP866frkf5J6n0x7q6XO
ohPVn65M2eVJv1A35V9qv/eZlF+YY79I2ZI5/kDsS9L+JbHPT7ow+cWSvpz6
26T+dOPqbxvG3jD2stpP+U9T97yky5K/OOmX/erzFyV/S9r/jWtLujb5M5J+
1sbD/RNVR13j5CN5HzPHXqT1lynyeyen3tyxV4q9kPHT1b1clPp3p/w956Vs
nPS35E9P+dHtXn87rvu7rF9j4tzkz0u6KPmL3WPy86f++ml//Zw/1bjG7utJ
L/VrDD+WOjf1q4+/0t7/p1M+Y9LUyS+ZtGDy8yRNn/zHUufg5L+V9jY03nLe
d2N/O/basT/Xle34Ifm9Z/J/x9hfS/mmKb8v9r6xvxF7Lf019rdi7510d/Lf
T5ou+WVSvkDKn499YOz9Y28e+4nYx8c+IelZfSbpsOSPTvlG5puurs91vpvf
XyH2kbF/6Bkn/3jqH5P8sUl/GlZ7xyX//Zy/sfEb+6jYh8X+UuxJco758bP5
s1XaeyrlJ2ov9iYpnynlC8eeNvl/pPyhlH8v9kEp/0KOPRj70NbeerFnTP25
Yq/Y5gP27LHnSJou+VOH9axXbP3h9NgLxV6lje/l8n+2Xp1jTvFO1HfeN9Le
Z3Ish3oxe0sl//GuztfOnuP6Db91Suw9xvWf/bnUXdD8Y+6MPVU7tmLq/6BX
79S7fTj1j07+4JStk/q/jL1u7CNjbxD7IxM13+6Q413qTxd70zY/rD9R/dF8
u0bSIskfm3ozt/7zRfNB7C/G3qitH8cNqy+u0dafx9p8+X9Jf0x+2xzfTn9K
+mbyt6T+1sl/NfmVJmp8mj+WzfHH9b/Y98VeN/bT+l/sPzT72dgfTVow585v
fCb/dq7xteSfSX6KjN/ftPPXSv0/tfnrRteSdH/ytyZ9zvqUc55P+YGp99fY
f086aFjltyR/b9Jtrq2r33cdk6f9c3LeT3P9ZyWdnfxm1qGUP5e0+bDWi6eS
fzrp0eT/2NW1TpbfeiPv84EcezxlX0zdP+fY3bEfjP2F2E/Gftj7T/15kh41
HvSPdq9vWp+SH6Z+P+k3yd+R83bLtXASVkudpVJ/l9i7xJ4h9T8Ve6vYv069
f8b+Q+xZUzZT0iPmkq7eh/fy7XHNt9v06piyW4f1/rzHz6X9a2PP1PwN8692
tf+V2KvE/nHs+dv7XTn2TbE3ib15W39+FXuL2Fu2NWSSpHmTPzjHR+33tk/5
15PuTP6upH2S3zN1Vk/dY4blryzfxsPNsTdr7a8Ye6f83zb2Tkk7G2vGdP7v
l3rDtL9X8vunbD9zWvK3DVv95Fdt893ufj/252O/0NVc9KR5I8/nL6Naaz7j
eaa839r/Tux+6p6W9P1+rQHWglOTvpf8sTnvduM5/0+MfVzSiclP7/2n/Z+n
jT3S1qvWrOQPTP7s1P9Ryg9L3bn1Tc835Uf1q01tT5Pye3P+JTlnT/5D/j8W
+49JVyQ/c8qfTv5iPlHKN0qbk+Tcu2N/OflZc+yU2Ium/TuMlxz/S+q/kXRH
8uflN85M+SdSNmn6/7mxz+rXMWUnpc65qXtX0vmDqqfs02nvt8nflmP/Tdm8
5oTkz/A8k/9R0k+T31gfT/lFfKJczw9zvQembP6cf1vO3yb2krHfTvlZ+lP+
/zP1/550Y/LbdHW9rnu+nP/N2G8mf6Z3k+t9OfarvaqjLvs6/cF1pv5WaX/x
tP9ujp2fY9ul/Prkv5n8z1J+VvMXPpXruae9nw/S1q2ps/W4nqvn+39JVw7q
PXqff0i6MPmfpP7hOf9kfsi43pP39UDSZd7PRD0L93v7RD0TtuNdrv+jOb5D
7K8mTcm3EgTw93LutyfqP/s9Y3xQ97NE7E8mbZ38m2lvRnNRyrbP7/84x05u
7/uunP81/mLKvpv8Ofpb7D1Svps+m/xOSb8zPlN+bso3TpoqZfd59sl/Ne0t
G/ud2NfyL2L/zf3F/l7sQ2PvnPLlk7ZPfqek1ZOfPb//65T/oL3vOWPfPFH9
Uv+cSLor+Tfy+w/l/5Fig/zeEam/l/6Y+jfl2K7WsNi/t86k/MH8n6ZfPrpr
OKrVnzn1f9WuZ4XYU8W+LvZKsd9pfemIiWpHex9Lejj5w1K+VfLbGHPJL5PU
tWs7bKLKd409Xdq7YaLG6xH9eufG/Fm5vtP7NcbONh+0579Q6t+Z+v/J/xvz
+0+kvePEWin/lfEb+4fGJn8p9edJvSXH1Ya2jNtJ0j9WN4fE/kPqH5tj27bx
YvzdLf5I/W/H/k7SScnPyf9P+z9N/ROs19aClH289ZEZc94Gya+XNFPyk+m3
qf90yk7i88fe3HqVtGvyz+X47Mn/u40J9dR/NukpPtaoytU7WZ+OfT3fLvYP
Jiq+Wy322rEXi71DrvE//Nmcs1dXPiHfcA1+dO5/zVFdr+s+I/X3T/ly1u/Y
i6b8iymfI/bz1mnX29Vafw5fKOV7pHzDlA/zu7/Isa/HXif2qu439lfa+Pmn
eS32aUnfMR8nnZ78FmnjA3NZ6j07rpjDemBd+Gjex/Mtftwp7b+d+ne6n9i7
iGONn5Qf3qs2tf1ii1d3TfnfYt/T/IHdY/8j9kHOT/lF5uacf1fsYezXPPtx
je8nY58qFoq9Xc57K+e/nrSVtTHH/pb8U6n/p+R3zv81vC9zlf4uZkh+39Rd
O+X78/f4pUkHJL9ljs2Z/Ch1/5L8v3P+dLGnTfpAX2rx6zdTd5C2Xsn/s3N/
J6d8Z3No7M/EXiv2p2PP5Z229z1l2nu2+UPrpd6bxgM/i79k3TCXDMvf4nft
OlHx+7Op/1rSE/y5tPdG8l/Wj9Len0Z179vEfs37ir2Q52Eti/1OV3P9Bclf
NS4MYsr2Wy/F/kjsjzR/fnK2dTv2ubG/zleOvWDaeyP2z2L/Rv+KvWN+b41x
xaxiV7HeXbHXHtVcMm3Sysnv08bPpKl/ec7/duztYk8R+6rY+7X5ZrLYvxQj
pb3Jk7+er5X2jkn5ASmfrc2fR7re5K9I/vqUH93V3GYuvkl8Gvsrqf+1pKPM
JaNaT6wr16TOl2LPF/sla1XsTWLP2mz9/Sswjdz/OuL0tLdB/s+V8hdT/uOU
7xJ7zdgftP6026jmDgHOxbE3jP0Ja1fSDBOFeYiTxcuwEPPJtv26xysnyi/j
n23tnSYdmfJ983+WNt8fmnPWir1K0oHJ75k0d/Ivp71Fcn2Hx/6S9TRpv67G
t+szhi7N+Xu39ef92JfFPiR1vhi7n/YXy/lnjgrf4t/9Tv2U/zrXc0bqL5zy
b7T5YpTyS1p/0L8WSNos+S+3/vGXQc0v/8r5e/drTbW27tbG357WiFHFqyel
/e1jHxR7hmG9q52Sphe759gW/XrHV6e9PczhsV9o1yNeP4g/bQyOqr7+tKJ3
nvxJKZ805UsPKl4/Ovbk5TL0jjC/d1Wu3m5p7z9dYT2woftjX9fioRVz7A/8
99h3x15tWHjVqtbVfmEsq1gD23o/TfKPGGOjwi+WHxZ+dP+wsASYwr36eH7v
NmMj+WXze6en/hmxl2jP//KuYsOHkr/P/K+P8Lfb+fAE8bs4Hp5xz7BiBzHE
7cnPN1Fxtnj78Pz5QdI0yc+QdHzyU3UV34pzv24+HxVe9dlh4UNLd3W9rvtg
/tGwnp1n+MNhYSpiY21cMyyMZK9exRBiiROaPzBf82e3zP/n+xUjbujZdTVP
v5qyx+FpsX+bsqdz3hOxh+PCHmE/j42rvrnvL0k3J7/FsPLmxI2S3zTphX7F
vJ65OsrVWzXnd+PCleBLN8EOkg7Ite4jfjK/xP5J7ONirzQuDAmWBLOD3e3d
1s+TjMmU9caFXT6W/APm35y/aOofmmPrjgujga14R3/MsZ/l/FNz7iebf/LT
2AfFnqP5o7ePCp9cM/YTsa/oqn/pZzunvYkcm4HvOyz84s9d4UFwocNSPv9E
9XV9+qgc+0iOzTWomFfs++So4v0DWzz49qjwuWWGhRe/Fft3xuuw8N/bu8JK
3kr+qbT1UsrfT/kkae+vo1q/3ol9hzk5dZ4ZFT791baeibHF2vMk/9q4/s/U
1lZA0ENdxab/zfGXx9WnjY19B9XXV0/5OS22msv8G/sO+E9+55TYy3Y1FoyJ
mWL/Nvaj/cIsYBevpt67ye89LDz67hz7U+wHc/zVceHPd5lrxBEpv7cr7Prf
yf9fykfjwsph7Y8mf0dX2PhfYz8d+4Wc/y9zTY79faLwtkXT1GnDwrNgYtZS
ayosfIH2fqbtFZY4S1f+AT9h73FhxrDWuXuFJcPYYG1z9QqLnaYrPP3ENl9N
2VVbJ8TePfa0XZ2rLvwMRgAng5fBDj7WFT4Bp4DHvZ7rH6V8t9jvTFS8YH39
Fp94ovCZh5L/b9JcE8UPABz/GXvO2OOk2cRPw8IvYGiwNJj7ozk270RhOfCN
iZSvG/t7sb+f8keGhfEoV+/1XM/zXWEX2/K5k394VNiSsY2vuCP2/bEfSJrd
OxgW1gpzfXFYeA88BC4Cz1mO/98rLPVI+GhXeAxcBn4Pk4GdOAdXsHXs42Of
0tqD0cFyPLMzYq8Qe/vYX2nz67NdzXfmvYPS3pfFHHzzHHt5WJjGBdb6XmEd
MOEdeoXpwnb1Y/35zqQpk1+tK/+RH3lM2tu9nX9fjk2X8k26wjdmSP60lG8W
+4nYM8U+fVwYxy8GdQz2ARM5he/XK6wEZgW7wlnhEp7J+bv2Cms6cFwYFiwL
Z4Q7wrmsF3vtXnExC3SVvyr5A8bl066Z8iVaH15jouZSc+pvY3+2q/XIuvTd
cXFguCB9GDf2Ylfvz3s8fFw4E7zpmNY/Nkv9HVP/a7Gf05+6wnPhuvuPiyPj
WxtDuDOYLGx2uV5xfTBZ2KwxiSuEccG6vhr7N7E37OrdTN3mExwbbnC1XsVm
86R81eQvTn4//lH+LxZ7qaRLh/XcPL/teoXdXWRNTv5zST9PfquJWkusKS8M
qx/qj1v2CuvfMu0/l/xs1v20/7WJ4rpwXqMc2yX2T/jrsf86LB50nUFd0z9j
r8d/SH5Svk7O3ynlp6f8BktTjq3bVTwtrj5xXDGENrUltphjXDjuWamzXvLH
Jw1Sd5h0QvI7tPau4zPx/bpqu9fKB+PCbp9KvYfEZzn++4zNtYeF594be6nY
bw0Kz94+6VS+aJp4P3UWT/mkzXeCf69ivu6Vb4BvvL6r2Og5sVran6Ord3t+
ju0b+1pzhPXTWjMujgXX8qPUeUx/7OrZvc73Sfk2bXyemWN/4VdYA5Ofd1R4
11/gZ7HnHhU+5rjyfyQtmPzebXw9GfsTsecfFw4Nj/5qV+c5/62kucylqX/z
oLCp/a0p+c0f94qDwcW81JXt+FFpa5+JwjCfz7HZc/6c+pz41zNJfjYYFt86
9vrJfz7n/8zv5fwfxt62jfcLc+zNYa2fxv5ryX8/5f/I/5Vjr5L0jnUu6Qr9
O+nt5Nfq6tm8lPxxqb9+V/GfOPBk8dSw6jrn3WH5fHwjPhJf0DgynsxZ5i5z
2j3mgrZmeyf4ru8O6l15Rp4VzPE7sRfO760T+wg+ZX5vvlHhU3cOChNesvWX
3w4Ks1u8q7nYnPyx1F9iVNjoR8Qwo5pfcGG4vSPMV2Iv8UvSYqOaU8QPBwxq
rllkVHgt3PZbExWv4+ON6bm7wnBhM/9pdf6c809O/tjkt0j9lbta26xxs44L
P8fd4QatP/qQvnRL6w+rpvxH7Vzv3xwhHvrBoOaOHbu614OS/7f5M+dPkd+/
d1CYpPZgn39tfXiBNn5+NSiM1/OFZb/a+vS1g+JX8axwYHPEz5M/a1BzB1wM
PnZLr2K+eUaFZ94wKEx451zP/ckfkvwH45qjzFX42x0nakyd2ytc3FjTrvb1
X/34l56ZtdUaMqj576leYcfztvft+Rhz849qDba2HzOotZm/tHjsC3P8m9bb
rtrS5tbJr9LV2m0N/8S4OIAXejWejCvXe621alBz7dqpf03s02LPPq4529gw
Rszl51nDerXGWev0geVbmfVgyhz7ZMoW42NNlN9nrbHm0FtYL9dzf/xD9xd7
TeOnrV/+s62x1lr+2byxpzFHj0ufgO/HOS7YVZK/uq2/T8b+9KA4MlyZOeXw
lJ/a5hQcOX4STym++0xX/gc/xHiYvCvfEKc6RVf87Eflk5YcVHyI78J7vTOu
Y8KeHP6wLv9TPCmu3HVc1+36+bB8WTGiWFMdsSM/lb/KBxar0HjQesDYD50o
v2Lt9jzoIy6JvWyv1nhrPZ9r+9hfHpQvRq9Ab4FDxiU7poxeAh9GL0R/4x3O
3pV+A9+L9z16XD4mXxMP9p1x1VH3vLa+4JcPiX1o2psl9idiL9krH2DWrpL8
mc1/P2tY+oCPJZ09rHXKesUnWbLNbxv16p3rC3h5/DyfiG+kn+gvfBC+CL/D
Wm/Nhw9b/zwPz+Vv4/JBVu/VmHANrm+J1l8/an2eKCzzsJSNu8Kx4FnPDgr/
3j3HZusXVr3QuPD469t4+OpE+VtrxZ4++ffH5SPwFV5u/il/la/7altfrLfn
x/577PfGdVz5iW0+EBOIDeh38Ok49jViv9HWZ2vaL9paZD2zDp3Zzudb8ynh
Y3hMvuZzOf+bsfdMWqYrn45vt8Og+Fc+Bl/jsqR/Des+3M+6bfxbF62P1kxr
Jz+Bv/CTNp9Z435p7ujV2rfBuPiKfvOnlujKN+WjTj8uf9HcYZ39Ed8o9tW9
8qn4Vh/6fL3SEG3JH+hKi0GrIH63xpsrrd3WW/7drW3unLP5Zle36+PH8cdu
6pUPx5fj7/HVJmn+IH3JEb3C7z9uvI8q1hBzTDGqeuqf3uZ/13NYr3Qrh7b4
4k+94urmif3xUfkWnpfYQjx3yKDGB/2I+OThXnF/+MyNuopdZmzxCp+eb+8c
5zqunL8gVuJvaP/jLZ7Bj+ISH0natKv+Q+9x+KBizVlG5YvxycQ+k3aFT5lr
xMP81Bva/fFlxXBiGzGO2G631J8lJ6wlrp2keBZ8C70Ifmae5p/w6VYclX/B
f8DJ4ctgOnxNPiesB94N78VJ/Gii/B3l/Bn6ExiS8X/UoLCl9UbF10wOc0v+
U0mD5B8ZFF8E77wl9V9K+kZXfh5/74SUbzdRccNzbTyfOFExgf7OxxYr0OvR
x+E48ZHrxp459uOD4rOMD+ONT8k3/3pX5epdNK7n4vngq45r13tar3yWU9r6
aT3VJ/X1D+O9QWkxxJN7DGps7pG0+6BiSvqtrQcVa4pjxbPWZr6vOPaJ9j75
2lt09X5nafGReeX8dn+ud9Ucn6E9r2Mmah5Zo82X7p9/fHEbu/xZcdJtvbr/
708Urg5f3ydp1mHNH9ukfLtBxYq75v8CvdKY0ZTAQ2nDaDHE++acD+8vx2Yc
lx5tvjb/zND8TXwpnwmHu+m4uMbVjKPkX+vKtz06Zf9t8Qff7ajY/xmXhmPn
Xs1p4tbjU74/rDvphK78Qv4hn1gstcm4+F888Lb8ffFy7N1Tds24+B/Y+A6x
rxxX/8d34D3wi5eMixPZaFR8Gv4N17kXv2lcmP+EPtwvLmDzUXHtOEPcIY7p
VWt/v7inPUfFLa7T6uMU/8qXavUvMS/2CwOFhfIvcSW4Inw3P8/aZo1bOsde
T/npvRor+Hh+qGfrGeOmPTfPjw8slnyrK37HPbk3fDouCseNO8f/ixVoKnbp
6j14H2IO3Lg+oq/M3N7Z+qPyrfhYuEzX6XqNeWMf50obQCOAi50kvzl17H/x
ZcelT4WvwlnhjzhH3COnCv6pnvo4RlwjfhLeC/fFP+IYcY04S5zkpHyS5IfJ
v5L8+Sk/J+2/kXOfHxeeCavF2eJu8Xz4vmkGxTXe35Vel24X//ezrt6H93LP
uDha3BKOyf3inPFknx8VFy2PK9OHHNtyVFzQQu39/7Wr/qGfXJ72/tZVuXpX
jMvHo4WlweX70a3QryzWL/2GJE+jQttxXs5ZflTPlxaDPsPcuXwrM3/RA6ze
xpc53FwOM8K9nyPeTvnZ1sGU/7srrPP7sW+NffSouCkcFa4Yp7RJvzShuCaa
HtoCGgPaHO1oD6YP2z9tVNwAjgDXTi97RfIXj0oPSx/+89jnjIofxVGt1C+O
C3eFz8RlfSf5G8fFUQ7ye+v3i7s8YFRaDBwprhQ/ynb8hnGNc+N9h1Z//1Fx
iXwmvhOOlVaAZgD36nf8nhhYLGxeMD9s18pxcsv0S1OKqztwVFydGFWsiufF
99Iw0/rCx2HFMHZY+0/0kX5xWrgteqAfJH/8qPRg+EXxtrgbv2rNM5eb02kn
+Kfyq7b16KQ2Hs3htBk0H7QfD7f11rxgfrBGWav0C/1jjjYeFxyX1oQPx5cT
fxvPxvXF41pDraV85IVHteZZ+/jEfOMTWrk1l5YERz3O8c3a+6B5oU2jWaOF
OVn8kPxx1p1xaZxonWh+aH8cV24NwvXSoNEm0cjQynynq/nTPHrduDjzLuUb
94tLp6uitcGx4drO7Kr/6Yd3jEujh8vF6dq78HJSf1CYP+zfngZ7BWgwaDFo
MmkzaehxJDd0hefB9eBr+Djaf2uMtcYeANp7PgZfg96E1unG5B8e1/4E5erh
7/AptKE4wBtTNjEurSytKH6FngE/haei1/h1V3wr3hUfSNNA20DzQNNBA/Fq
v/Y00EbQINAi4CbwVfBD2lec4Obj2gNC+07TRttGo0KrQsNA00KjQquC68Dv
0K/gd/A89CbPjOsZ0qDQoozH9TwdU0YPgW/CO9HHuC/3RxNMG4tDXint39ov
bhm+A4uCVX2oPxuXD7dqr2IJmJA4Xh/VV8VYYpazexV7iWHFEeIJsS0MHZYO
A4GFiPHF+jB2WBifmo8F0+Nrw6Rg0jB3WJUxZqyZQ82lfC4+5jO98sVoQGH0
MC5Yl5jlQ+6xV7GDmIGuXEzDPqn5XDBosQnMGLYsZhG7iIn+OywMhv8Ig4ch
3t0rrk/MwEe8v1exhBhRjGbPgNgRp4Bb+EqvsEAcNa4aJ4gbxIl/yI33Sh9+
XIsp+dB8wwO6mt/Mc/Qi/+1qL4e9Evj/e8e1J+WKUfHvdMiwloUHpcWmb6bf
peOlT8bv2RswS680Bfg3Wt05e6Vlp4Omh6bhnnyiMBDa/UGvsBF864fc2qC0
R/xD8YC4gB7WOm+9x7nh3vCDsJZ5e6WxhxHQFq3UK+wApiTWFfPCmt4dlbaI
xuifo9qnZG8GDvjt5g8oV+8F/n/SnsPievGh+FpcKU0VbRV+E3YBw6DhX3ii
9lHZT3XksDAz2A3MAqYCE7O3xB4TWNnUMIBBYWiwNPOG+YOGgpaCH8OfwSHg
Evrj0qbfmfyDyf+8q/XFOvO7ce07oT22h+vS9t68PzjTci3RVl7TrzL7WOxn
oXmgffigq/1HzvHuaeYf69ceIFp6mg5ajdva9dGL2FuDo8fV0wPgwmkYaBns
QbIXCTdOH6Bf6V80/7e0e3Av5oNrutJ7uDYaUFplGvyF+6XZp83Ht+A+cR64
D+d6Hre0+WT5lK8zLG4UH2NfgP0B2tCWPQT2EtgjYK+AfWP21tCo0KrQ3NHe
0ey91tZEayP/j9bouK78I37SLePym/hPOGPaLHwq/hfGhmOF8cB67NmiMcHP
wbZgXDBM/Bw+EsYIoxSTi81p6mnyYXiwPHugcLrLt7kOhkJLT9dI3+j5bDcq
jT78D0aIjxNzi71xCjhDmJDYTIyGA4dZwC7MD+YJcZ34jr9Hew9jgjXZY2Cv
AU08bQKNAn3LOm2u+16v9p6s2cq3aNeHE8GNHNyrPUf2FOEaDmr+pDhZvLx7
a9/cSRspvoDlwhRgC+ZX8yxMDjZnvjRvinHFwmJisS+MDDZgfjPP4RXE6vwh
XMVm7fftWbJ3yZ4i2DqMHR+Np8BXHNfKrS2wGpgN7GrrVv/odr/iOVpRGmha
aJwF7uLk9nt4F/wL/9Feq01a+UnNn4QJ4grO6RVWaG2AccG2cJUwONyC+d68
D8PxDNw7bOe9hgnAL3BjzqGVtL5oC6aFg7i1V1gXjI820/ppHd2uPS8aS3zo
zq0cZ4EboXmkffxN8zd3i33eoDTs+PTdm229sm4dH/uZQWl++a8wjUsHtX5Z
x/Zu7Vl/rcMwKxr6pxrGAVOjkYe5wcD2nSjO5Obmb+Kk8In/aj4zTgZ3BqOC
VeF88Dr4HVwQjgn3iCPCFe3Vrodmf+bWHh4Ln7XoqDAtWnAcGqwLxwY74t/h
3nBwuCscDa7GHgqadVwafgonBcuH6eOqaOTFw7SP+CKacdpxc7C5GCZFpz51
8x+Xa3M1LkBdnKB9GDgsXBYMBfYGg4OtnN/6H/xBfAjzgH3A6uAnNJywzyN6
hXHAGO1RgFHCHo9p8cP0LcY4psUf1twZJyr+p0Xnv/BjYIQwMTHEgi1e8L75
R/wkewzoyGE8sB7xAk6NhhL2LkYRq9DEwgt+2Nqn6RZP/6DFGzA3WKR4h6Yc
Rg+Tg8vAMsTdZ7REC26PgzJ6UxpV2lSaaHgELTjNquOOwSbhFeraU4Kbt76K
Z8VftOr2ePA5Tmnni5/EUzS/tMTie9pPew7sGfCs4FevT5T2iwbMXmX+Oq0k
H542mc6P3u/1ZsOTaElXjr3jqOIp2t992vx7aSuHH9Gy0pTSrn+mX1pTul/a
UPHzvqOKj2iLN232Za2+eHzv5n/Tctrja6/vee1+PtXWDxpFWsX9+rUXh06a
Xnrxdn00vrTjn++X9pcGmRZ5tX7t7RCv0xbvGPuQUe1Z0t4RLR60x4PW76AW
/9G00j6Lt8X/VzV7xzZfXtx+Dx5BO0sHT8u7Zvv9K9v90lTTEtOt0q/yV+x1
/lW7PuszbRcNKl3kjc2febS9Hxo4Wjgclb3s9tjjrmjYPvTreqVto0mlTT27
X1phe+RpRa9s/pY9Irv0a0+IvSHvdw1/cO/j0mfDD+AIvxrXHoq1+6WBdv1w
Rnij+xHf3tN+74wWr9kzQjsJbxEf393sz/Zr78eHGpJh6XH5V/Zne8/2ctPQ
0lTSVtKQ0ZLRbdJv0vDT8tNY0lraS24/vXPob/lr2rqrvb/v9msv0f3t/k/r
195qe7hpKfnTFzZ/kRZ4ijYf2gO0dL/24NiLQ9MNg/5Gv/b20K3Tr6/Q1lMa
GFqYp1r8+EK7/pvb+6WJo42jfxX/0snSy4o3H2v+HF3fb0e1twLHi9vF8eJ+
aTxpPQUgtH04Yn4Yfwz3i9PF7U7vnK50kPSQz7TxDS+g9YER2Nv5fBtftzR/
VXxNGymGtjeEjpSe1B5c3z54s80XNKS0pPSlcAh7Qegp6SzpLf/dzv97a48G
VV26IPqgx9vvP93ms0X6tZfWvdM2PtKvZ0AzKS4Tn9FS3tDmm61af8UZ4Y7w
1bjt/+1BFr/RVtrjSHsLk7X3ERFOy4pjxbXCZz3P37X+5JsOtKfvtvulk6KX
ssfF+9AH+eF/an3zyfY8aS5pL69r/Wfn1l/sg7BXYNs2v9Dw0vLOPai9nnS0
9LQztuv7oP3+RweF8dJg0mKKWSedKA2x+5l9UHujaULFkeJJWgSaTtrO+QYV
49LF0sfCjP8+qv0MvuUgRhQr2iNsr7AYRCzyfhsPV/Xr2xTvtfcBf4JHjVv7
s7XnBwPk1/Bv7L14oqv4UJz41rg4Ceuc9c7eHxgNrAbmCHuEeYsZaYBpgcVc
Yi8xmdiMBnzb/N7b/dKGi2nFtjByWPmaMORhYTqwHRpwWhvjlzYcJgV3gj/B
qmAC4kgxm9gNpwJDha/am2XOM/fRQ9Kaw2hhtfDCI7ra02LOhOHCcmEQsAhz
pLnSnh57e94Uv3X1TZF3RoUhw5JhTsaK/VOu15xqbqU3dL04BdyCmF3sjoPQ
J31vBDcBo4J7wb9gVzieS9sag/sxH4oRxYbi2/tbDCvmFfvC+MTs4mF7GWj4
YXI0+rT6YlCxqJhV7OqbB759gP+k73q0YWQwQdggzBsmjVNfor1Pfcb3VnAb
MDhxqfgUNoezwGnALGAXMD/YHwzl9lau3+v/9jrBNPTbSVt9Nqxjitj3daUx
FPPDDK9vzwsn45stD7TnDzPxzRPfPoFpwjZhorBRe5BwBjB1WD5OxpxhfzSu
5pWG4djjbq+7PbEnjQoTh43TNOG8VuTvd8Up4hZpTGl1YcgwYxwgLhDGC+u1
58feH5g6bP3Ifu2PHk1S64r1xX5WGgVahR16pQWyx9Y+bPux7b39n0b/W2LR
ce0h5mfxt+wtHkxS66z1dr9W37xj/qH1N0aNaXoTYxfHgiOxZ9read+U8F2I
2Xv1bYnxJLWOWk/tz8SJ4EYu7NdeMhoomiLfU/E9EhgPrMc3T3z7hCaJNsn3
UHy/BSYBm7BH6tDWn/kU8PLvdYWhw9Lxl4d1xYniTD7kV7rigGAa9ozaO3p1
81H4JMYDDg7vhn/7fRv/fAT+BbyIxouGx/d6fM/EN1J+PioOCBdkj4K9CjTA
tOk0i7SLNOm06b7xgnveplffIvDNAt8YwJf73o1veNAM+Z6Q7x/hlHBLx/Rr
vz3ODndnz629tzRCtEK+J2S/oWfoWdJM0U7RNNFS0FTQOtGI0GbSaNKOwIPF
HeIPXAxN3bEtvocvm6/FNeIbXI49WXSDt/RKuwA/EkPAIODX9rT6hgPNrL2u
NES0RDRC8Gz6oldaHE7PQkN5cMMb4M04YTEgzhdXbM/biy2+gU/Bh+Eg8BBa
JHg5XAG+QAuL4xZXia9w3zhhsZI2cMU0gLSBNA20DTgi2mlxmngPp4gHxgfD
x2mAaIGu+//wbbgEfAK27Z15dzQPvl1DE0BHQE9AK6DP6rs0frR+NGdwUngp
rZd35t3RoNKi0pjReeHEZ2nj2bdrdmzzJU0gXA2+RnuoD+qLvmkyf+vvYgob
wmgD/qdBhA/TetE0wMB8b8LeBnskYG6+V6F/fqiXG9S3TOzV0Af1RRo7Wjt7
LuB28Dt7MWjqaOv0aX2bJgTm5Xsdz7T+r2142eJtvlMGb6OtsCfR3kScpuul
CaMNo+mA39OLvdVwHPgP/gPGBHPCd+BUYBg0ErgWfAEMD+ZGq4IPgbPAW2id
6K9oneE+9Fb4DhgZTAw/gl+A4cEIaUFotGi1aJbwKfgOONOtvdJu0YT7ZoFv
FdCK41PgPPAe2lea1ed7pVGlZfUNh2vS9iu9+l4Df0fMro/qqzTqMB96XNp1
a6i1lKaItvCscWEmMCHfcsAZwGxoGnAJNO0wIhoJWhMaBDwfvu+qNj/5lhF8
EH+C34FxGoP2muGnaNsuSfmaXXH4MATfp8Dt4/hhBPYH4/7xLbQ39HO05fao
+1bCss0/OnZcmuEzWzk+izbTnGRu4k+d32Jw2hV8Dhz14F7tfcSPwTjNSbT0
NCEwKD4brQg+ie6c/txeD/wUbZs5zlyHH4NRGkPWQ3wTXAg+RMuGH4OJeibm
axoD2BSMi/aAxo3WjUaNVu3Uce3z+V37veEkhQvAB+zXnZikcAX4Av0OTSVd
wrpt/NEU421W6pXW2PiEW8Ov52vjm06CXoIWWLyCNxr0SvsmfoOzw9tpf/m7
9j6+Ih7uKv6xd8x+NHtf+bf2p+DMPS/xjr1jc/XqW0z8EftqPtPmG/EB3Hy+
Xn3byXxk3w/N6axtvoD7w//xkfxFmITvreHW7HFd7n/4S5vv4AzwBtrbfca1
L2jWFp8tE3upYXE8uB57NO0vsufK/MRH4avgxPhX/G0xne9RwB7gw/a6XNDW
A/7xdS3G5l/DJD/cl92v9QRmCDuk9zM++Ks0foe2/gbjhHXibM0nvnng2wdi
BrEDPkcs5/tLuCrfXBDz47Rw4+Jp+/6mbfEl/1nMjMNQbk8+TQgNhv7um172
8Nq761tf9pTaWyom4l9ZH+01sAfU+Fwn9iHD0hDx7+E3eDZ8G300fwTn5Rtx
vhW317j2Gc7d4lvzBdwP/vdqmz9x0zRSX2vrg71u9gSb/+C/NGi0Z/gq448G
g+bC+ID/0mjRZtHr8E9gRr6vSGtkPbCHyh4x87H5zT4G+xm2a+s9jRXN1htt
vqEdoi/bp6tr8y7gwfBq85t9DvY7vNzWe7jvEb36lga8ksaLtov+C15MM0Yr
Rs9g/qJVok/bt61fOCVr3tNtfcND4aN8H4o/CvPx/T79k39k74E9PeajpfWX
YXGY57fxToPMx+Br+Oaeb+/p4/o6/5em5oIW3xkv+EacJG4SpkzbRPcCa7Ze
+PbPy/m9bbvyt2FmvtdD6/TZ2IsMS6N0Tpt/6X9w3rhvPivf1ZjUPn8Sh3p5
81d988g3jdyDe/HNFd9e0aa2+aP21S3a8EH+GL0YzR1/SnzhWz4LpM5S4+LI
4QjwhMfbfGcvxcq90jvYAwqHgEfYG+qbYXAKeAWuHcYMa4bPW8+0qW2aNf3J
N9DgPvAf30YTX9HI+OaSby+Jj2h0Dm/xFv/YPsHlmr8lPr+yYSzicfEHzfD8
DQ8RP8CUfT+BNkf8YQ/UzA0v46/bR7pZ83/EA/ZNrt38MfgIHAoeZX+y+A2m
6Xs4tDswR9gjzQztjG/e+PYNjRAtkf7iu4m+n3hRez40BQvkeh5r7wsuC5/1
fSrvCy4Jnzy7zZ98u30aHuF523trzlinvR8ah/nb87ZH3jfefNvN3nnxFUzZ
94RwweIlmLbvF9HSiedhhL5PStsjPoZJ4pivbvMlHAge5Nsx4lkYue97uT/f
HKEhoB3wLRJ8C13hrM1ff3tc+5inavglvARmyqfQn+EHMHWcgPhbPAo7skfG
Xpn/BwtzEGw=
         "]], Polygon3DBox[CompressedData["
1:eJwtmHWcFccSha8PEhyCy0KwAMH9ZQkQ3N09i7ssQUOAxd2D+3tIgODusLi7
u7uEoHnfoeaP85uu06e6+97pqarusOadqnf0eTyeMK/HE+Q5KOTxlKKd1u/x
bIPY6Xg8PwQ8nj2ItoMdoA98f3Ql0X3E/h+2P4bH0xxdOFx28Bh+EfxodD0Y
NzbjbcbewXgT4XqiyQC3Ey6IbwS+xeAKg1f4LoT/Ce4E7ePgNWNkxF5L+z7t
nWAHWI2dDO0pnqfBGTBSvqA+7TpoWvAshj2YefMzvp95V2JvZC356MsDcoJc
IC9IiC4VfmXFoeuBrhRzp8A3ObgAPwq+Ebo77hoisWej+x2uLJpPcMvg1sON
hIsDl5B5N8JtgxsO1wouLlw88B77Os9JjFcE/g3+a9EmQtuIdn34LfS/w64P
rrOe5/RXgduEbzvwDs1WtEPgF6NJyvMo9mye1dHXAJHocjH+U/g58KvQ9YDL
AfcCbh7cX3D1wBX0fvp+ZY6TPMeBjuhSYG9BF+C9pUQ3FL+xzH0B/h/sPPgd
gIsGIfS5sRPhmx5NCbjs+HZDlx8kwacJmsbgA5qBaJvRrgB89K3XnoF/id0c
u5H2JXYDfB+j/ayx4I6E7L+v6vr9yzwDsJOia0k7grnbgoJww9GMAYPAYBAF
KqMbjF8KtCnBJXQRcC9pF6C/GXP5+L0N4YLMGaK/Jfo9+n9AFjQP0c4Pmq6K
9hv2cOaM4lkZOwKdF90+7H7Y8xgrIaiJXRvdZsb7G3sSugHowrB3oNsFl535
P6FJB38d/ST4y/DX4Fugawy24zcU1EUTE3sNms1oNsBFo7uCXRHeB9cOlKd9
FO1R+uKw5gs868L9CLbCn8f+lnYH2u1BO5AUuxy+7TUO63iIJi6+jeF2+WyN
2eA+OraWevg4aGNo72LXgS9J/z3WUhPOjx0FXwJdAHsF/Aa4rnAZ4G4x5lS4
ZXAX8WuIpob2GfNkxV6DbhvPc2hKw3vQ/QKe4fc9/k3o87K+aPoi6a7jrme1
5sf3GNwKtN2wZ+IXib4BmuIghG4VfBq4G+j2goVou8NlCdi3tgW8hc+MnQ7c
pn3NHbMHui3McRr+Pu3ajBdgjnD6wvQuQVpQDLsWfF50F9EV1bz4xaSdmL4E
YCBcMGRxo7X7HhKBUdjp8J2OZhNjhRjjA3YC+iLQtdTeBl7s+ooxHts/Exh7
ieIQfGy4BKAQfBb4WOiG+a0vpmI3dgvw0WPxv3fQ3m8MuCFohgKm8MTEzqe4
RjsO3Dr9fnR/wa1lXaeww+G/YPcCRXF6x3iL4degOwD3At0/2G3R7cM+Cx+m
+IVdVTkE7gz4Dr/+2L+BWGjGwnVhvFTYqcHHkMX7Wspr2M/R99TaGD8vXB6X
/5OxZ4D79GeGe8Bzuv53dMf5HUfAIrhOQduntd198R6uL3aU3/KG8kcOMAi7
GvwB168jftNY32S4fsqN9O+Fc9iTyf0WTzuDTiAZdlN0D/HdgO9G8EB5FkyB
G618hu8Qxsvm2DusyDqTyh/NFZBZcY9xHP2XaD6g6aK9o1gMXqLPCVdGeZMx
c4PZigPo39P3GrwBd/GtCPrRl0y++Dxxc89dr8WJZ3BXHHv/+vRC9vl5RmCE
07hJ/3G9d6+9t2Jwt+E2wW2H+xfuFe2uel/w9/SdgPnYBRknDygA5mEf1F7A
p6P+e7S3GOs52gBr84IOii/wt5UTlEtAa7iXcHEdy+ML/DZeGsaKD1cVv4rY
q+DfYMcBpZXz4WbBvcKOByrAlYJbDvca+xD+DlwsffvMdwcuoPxDf0Z928DR
vHBJ8EsMRtHXHl0J8Choseye9pIbww/Sfgsi0D2lPxf8f4O2XxUbtdf+oP0H
7Wkgh74P+hfCz8fOh30Iez9+ZcAL2jf1LdG3F81o2r/RngCyKm/RnxPdgqDV
baoJ3iheByyPPXLjZ13sIfCFaOfEbz/6ffhto92Q39UX/Iq2nOKvY3tCeeS2
vi/sY9iFFdexV4OV9M1jvOm0Cylv038I3QrFCLgicMfhDitPKMfTvqR6wmv5
7ar2KO1oUArtE+0FnuNZR0vQirXUU25FNwvNTFBQ+1vFLYik3VO/Q+OhKcsc
rzSGchbcfub4D9x51R1wh+HWwn2mnZCx44H4ynPYWdD1DVp9/EXzo2tKuyA+
CxRjtG9VJ4H0KrJBZ+VNdJVUd2kvo4tF/1Ps78EY2uW0LuAhRqSFaw73WvtR
euzvwFLGuoDkvHIa41WDW6P8BB6hG+dY/aJ6RO80K/O8Vg2mPUV/G/AJ7g59
P6K7qvegfQi+Yd479E9nrBlgPHM1ov80XBT2NDABrrH7zuvA3/FaTap4kF0x
gv5M+sbRdg/Zvq+P7qbX8uEFx2oG5ZJeOmegfxyy3D0Xu7HilM4Cyj1w4+DG
Kt6gex6yvaGa5zGay8qb2LVBEdqD0Q0Ci1SLKiChq4KuOhgYsvpLdZhf8Z7u
darx9L/6rR5UXTg1ZPVpYr/VPqqBxsClVexUjAcX4W4ELK4VU62GvQf7jGPx
T/nqPNwxxUDsTI6dE9Jj32TehozXyLG8q/w7UvEK+zh8XNUZypWKi3AZHatR
UuJ7GW09NFkdq/VVi7yEewjXG5/k+KYGqUAv7PhostPOBnJrD2OfR5vIZ/WF
6oxnjJWBZzv0ncAJ1n2AcTM4lsMS0l7EHKXxe6JzAX5Peb6l728Qhq6t8hrc
ZnSV0NWEO0n7BPhWsQv7jGuLPwfOglKq2RSD9b7BLnzLw30KWi5STorHnryG
XRndGTTnwBHtVf1XquuVv4P2/6UHHWjHpn83fVVCXz+lr7kpZGHAo88rHY1K
jHeD516IfeC06inldtU0ysWK2TxH6P2oTlcd4Fgu0fmwiM/iu3KU4ulrn51h
WzDWauyCqo+x14ESaM7inwC+Orqa+K2He4udz7F6TjV2lPKjY/Va6oDVn1fQ
NsAuAl8A3XJ0i+Fj8cNSwQ1SjQgaMv4Ix2qQuKrr9bvwrR6yejdRwGqbo3C1
sAur7mS8hYw3Fz4m4xVULIKbCDcJLgQ3JGDnvuTut9QRuwBz1WLOaoxVA2yi
r4TOOYoN2E1VM8MlZrymcE1AOP39sNeH7Fu5rPgOTsDl51lFuURrAxv9dsYO
c2vrW3CNsbejS+e3eqovGElfHr1LfMvo3A5W+q1m1VlEZ6cPcL9gb1U977f7
h15gmHILXG64udjzwBy4QqoZ4OZgz8KOEcPO2OG0oxQrmau1anHtN3T9FR8C
dpfhoz8t/WlAH7cwaqlaDLs0ujYBuy9pD1+c9lD0J+l7hv0c/VJcloApcM3o
O4vmutdiXQu3PmjFeClpd4MbGrCzeBGdz/HrptgBbmI/QDNPNR6YqHegd+bG
4Qc6s4IG2Hl1pkYTiaYsmgGMXxSuP1xvuPJwv8OlAP11flXtpDirvcxzGPYY
tMOUk/x2z5Dba3c5+iZUW7RR3UrfFNUwAauBq+HbVzWr6lvFBPq30vczz5I6
f6AtgJ2Jdg/akYrhIKPf6sjiigeMsVpnwYDdZfzgtfunJ6p3tQ7lS8W2gN3N
6F7gMHZ+fBdhzwYz6KsBf5A1nAJJ3Hh1gucl+k+CCspzqn8UI/U/gx7ac5of
3w1ofqLvlnKlu8d3eW2NqnvPuGeZ08oJoBz83aDtId2DpQB94D/hN0H3CrQz
o9kFvxtNK54zmW+dzgeKYTrbgi20v6CLoL8l6ISmC1xz0B509lmu2OyzezTt
Yd0PqcbUOUZn3dZwa7GXB632031GTZ1NdF7SGS5oZ2PdLegcr3i1KWj3NbrH
GuW+X51tUoHJiichO//e8tq5XXWv8n5T7WG4F+A5aKK4ErS7xM/6/pVvGXdJ
0GzdM5YHbQP2LnW3o/uh9tjrHLvLuK7/CPsIvNex70N3VIpbXeHGK6eAVfz+
teCzWyMpr6702VlPsVF3ALuVU+kfi984MDFg70b3lWncb2443HrlOq/l+Oru
u1S+XMx40R6Lvzr7KU5/jdfgT7AoYP+RzoKKY4oJ3eGiVUtiT9V+1L6EW8aa
l9FeCpYoVjkWS3Tnqv/sZ/h+aJrrLMWcOojnDNjdUjTcXZ3nVD+C63Dl4Fbq
fgK802907Cx51Wd3HMo3uhd4qRyD/UFnM9WKftsHusfRHUpPdJscyy/Rbt2p
+vMb7Ap6R8znBUkZ9xRzzgLjlU/AZDR73Xpojc/uTBTjdX+qfKO8M0J7SnUY
9v8BS7ve8A==
         "]], 
        Polygon3DBox[{{1804, 579, 43, 47, 924, 1907}, {1806, 585, 56, 57, 932,
          1909}, {1570, 62, 61, 63, 935, 1911}, {1803, 576, 37, 42, 41, 
         1559}}]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ktIVGEYBuC/phsyo5mMBmaRkaBEiEUSSAlB0FJpoStRbKFZk2hYK9EI
0moWkhQtlaAxJpmSWugiXLQIWhR0sV0XSxdRQZKiRs+hxcvzvd8/c+bMmdnb
lmo8vyGEMC1bZZtsks1yZGMICSa2hFDA4/oe1nE3S+wr2aWfZa3eyU69g5/0
PnO3OcUL7JOP9r36JXOLD0/GQkjbnTMXmzvYLivR5+pnzIVs4KBdI3fqKfbK
ql2ZftFcwQHetrvCtAzJHf0aR3y5mxzlreh1vMG7zq/zgZ5jhhO8xyyzzu9z
XM9wiXm+wwpfOkuY/5jj/MsdXGcR30XPiXEPtYr5PMDtrOFhOSTVctX9H+QH
7ynlZX0X90meH6hf/x09H856zQ/zT2nTf7GVz+wXzQvSrM/o38zfPe+nrrPI
J2y1XzDHnH3Re/T95s/mCs6znN3R+71uSv8a/Wb6PHP6e05wjk32b/hWXslp
95v0DF6bX0iB+TnjfMwG5+vub8r8SJbNOa5xVSbNp1wzyyX9BDM8xnL7eh51
rZN8aF/LMSaZ77yYI3oJ04xzOPb/f/4PG39dKQ==
       "]]}, {}, {}, {
      Line3DBox[{566, 565, 567, 1319, 1885, 568, 1320, 569, 1321, 570, 584, 
       1328, 1806, 585, 1329, 586, 1331, 588, 1807, 587, 1330, 589, 1380, 665,
        1379, 664, 1823, 1378, 659, 1375, 660, 1376, 661, 678, 1827, 1390, 
       677, 1391, 679, 1392, 681, 680, 1828, 682}], 
      Line3DBox[{572, 571, 1803, 576, 1323, 577, 1326, 581, 1805, 582, 1327, 
       583, 1338, 600, 1339, 595, 1809, 594, 1333, 591, 1332, 590, 1384, 671, 
       1824, 666, 1381, 1382, 667, 1385, 673, 672, 1826, 1389, 676, 1396, 684,
        1393, 683, 691, 1830, 1398, 690, 692}], 
      Line3DBox[{575, 574, 1322, 573, 578, 1324, 1804, 579, 1325, 580, 1335, 
       598, 1810, 596, 1334, 597, 1337, 599, 1336, 593, 1808, 592, 1383, 668, 
       1387, 1388, 675, 674, 1825, 1386, 662, 1377, 663, 1394, 685, 687, 1829,
        1395, 686, 1397, 688, 689}], 
      Line3DBox[{618, 617, 1348, 610, 1812, 608, 1344, 602, 1340, 601, 1360, 
       646, 1820, 643, 1359, 644, 1364, 650, 1365, 640, 1818, 638, 1435, 743, 
       1436, 1437, 727, 726, 1891, 1424, 724, 1419, 725, 1430, 737, 705, 1886,
        1402, 703, 1403, 706, 739}], 
      Line3DBox[{620, 619, 1815, 614, 1346, 613, 1345, 612, 1347, 606, 1811, 
       605, 1361, 636, 1355, 635, 1363, 649, 1819, 647, 1362, 648, 1421, 730, 
       1425, 731, 1834, 1422, 728, 1420, 729, 1429, 734, 733, 1835, 1426, 735,
        1428, 736, 1427, 670, 669, 1836, 741}], 
      Line3DBox[{623, 624, 1816, 622, 1349, 621, 1352, 630, 1353, 632, 1817, 
       633, 1370, 652, 1366, 651, 1374, 658, 1822, 656, 1371, 655, 1431, 738, 
       1438, 717, 1888, 1410, 718, 1416, 721, 1415, 699, 700, 1414, 1833, 698,
        1399, 697, 1405, 709, 693, 1831, 694}], 
      Line3DBox[{628, 627, 1351, 629, 1856, 626, 1350, 625, 1354, 634, 1369, 
       615, 1814, 616, 1368, 654, 1367, 653, 1373, 657, 1857, 716, 1409, 715, 
       1411, 1412, 711, 712, 1887, 1407, 713, 1408, 714, 1413, 719, 720, 1889,
        1417, 701, 1400, 696, 695}], 
      Line3DBox[{631, 609, 1342, 607, 1343, 611, 1813, 604, 1341, 603, 1372, 
       642, 1358, 645, 1821, 641, 1357, 639, 1356, 637, 1434, 744, 1837, 742, 
       1432, 1433, 732, 1423, 723, 722, 1890, 1418, 710, 1406, 704, 1401, 702,
        707, 1404, 1832, 708, 740}], 
      Line3DBox[{783, 782, 1462, 770, 767, 1841, 1450, 766, 1454, 772, 1453, 
       773, 751, 1440, 1892, 750, 1439, 749, 1445, 747, 748, 1503, 1899, 842, 
       1498, 1499, 841, 1509, 850, 848, 1854, 1505, 847, 1519, 869, 1517, 867,
        862, 1859, 1515, 861, 866}], 
      Line3DBox[{785, 769, 1842, 768, 1451, 764, 1449, 765, 763, 1448, 1894, 
       762, 1455, 771, 1452, 746, 745, 1442, 1893, 753, 1441, 752, 1502, 846, 
       1504, 845, 1853, 1501, 844, 1500, 843, 1508, 849, 839, 1852, 1495, 838,
        1494, 837, 1516, 864, 863, 1861, 868}], 
      Line3DBox[{790, 791, 787, 1844, 1465, 780, 1459, 777, 1456, 774, 761, 
       1840, 1447, 760, 1446, 759, 1444, 754, 755, 1839, 1443, 758, 1506, 832,
        1492, 833, 1507, 1855, 831, 1491, 830, 1490, 829, 856, 1518, 1862, 
       855, 1512, 854, 1511, 853, 859, 1860, 865}], 
      Line3DBox[{792, 793, 794, 1467, 1895, 795, 1469, 799, 1470, 800, 812, 
       1476, 1897, 811, 1478, 815, 1480, 817, 1481, 818, 1849, 819, 1529, 878,
        1525, 1526, 879, 875, 1864, 1522, 874, 1528, 880, 1538, 887, 886, 
       1867, 1535, 888, 1539, 894, 895}], 
      Line3DBox[{797, 796, 1468, 798, 803, 1472, 1896, 802, 1471, 801, 1479, 
       814, 1477, 813, 1848, 816, 1482, 820, 1483, 821, 1527, 877, 1865, 876, 
       1523, 1524, 872, 1521, 873, 871, 1863, 1520, 870, 1542, 892, 1537, 893,
        1868, 891, 1536, 890, 889}], 
      Line3DBox[{806, 805, 1846, 804, 1473, 807, 1474, 808, 1475, 809, 1847, 
       810, 1484, 824, 1486, 825, 1485, 823, 1850, 822, 1487, 826, 1530, 881, 
       1531, 882, 1866, 1532, 883, 1533, 884, 1534, 885, 1869, 898, 1541, 897,
        1540, 896, 1543, 900, 1870, 899, 901}], 
      Line3DBox[{789, 1845, 788, 1466, 779, 1458, 775, 776, 1843, 1457, 778, 
       1461, 781, 1460, 756, 1838, 757, 1463, 784, 1464, 786, 1493, 834, 1851,
        828, 1488, 1489, 827, 1497, 835, 836, 1898, 1496, 840, 1513, 852, 
       1510, 851, 860, 1514, 1858, 858, 857}]}, {
      Line3DBox[{906, 903, 902, 1319, 2033, 907, 1322, 919, 1904, 918, 1323, 
       921, 1905, 920, 1346, 964, 1348, 962, 1917, 1342, 961, 966, 1918, 1349,
        965, 1351, 969, 1145, 1983, 1466, 1156, 1157, 1982, 1465, 1154, 1462, 
       1153, 1135, 1974, 1451, 1134, 1158, 1467, 2052, 1159, 1468, 1160, 1169,
        1986, 1473, 1167, 1168, 1987, 1170}], 
      Line3DBox[{910, 911, 1903, 915, 1320, 905, 904, 1324, 1907, 924, 1326, 
       1298, 2034, 925, 1345, 960, 1916, 959, 1344, 1343, 963, 970, 1920, 
       1352, 971, 968, 1919, 1350, 967, 1458, 1144, 1146, 1978, 1459, 1147, 
       1132, 1973, 1450, 1131, 1449, 1130, 1162, 1984, 1469, 1161, 1306, 1472,
        2053, 1166, 1474, 1171, 1174, 1988, 1173}], 
      Line3DBox[{914, 909, 1900, 908, 1321, 917, 1902, 916, 1325, 923, 1906, 
       922, 1327, 926, 1347, 958, 2039, 955, 1340, 956, 1915, 1341, 957, 1353,
        972, 974, 1921, 1354, 973, 1143, 1977, 1457, 1142, 1456, 1141, 1139, 
       1975, 1454, 1133, 1305, 1448, 2051, 1129, 1470, 1163, 1164, 1985, 1471,
        1165, 1475, 1307, 2054, 1172, 1175}], 
      Line3DBox[{930, 929, 931, 1328, 1909, 932, 1335, 1299, 2038, 954, 1338, 
       913, 1901, 912, 1361, 982, 1360, 1300, 1930, 1372, 985, 986, 1928, 
       1370, 994, 1369, 993, 1149, 1979, 1461, 1152, 1128, 1972, 1447, 1127, 
       1453, 1137, 1138, 1976, 1455, 1140, 1308, 1476, 2055, 1176, 1479, 1182,
        1197, 1994, 1484, 1198, 1196, 1993, 1195}], 
      Line3DBox[{937, 938, 1912, 939, 1330, 943, 1336, 947, 2036, 944, 1332, 
       945, 1913, 946, 1362, 983, 1365, 978, 1923, 1356, 977, 995, 1929, 1371,
        996, 1373, 997, 1150, 1981, 1464, 1155, 1123, 1970, 1443, 1122, 1445, 
       1115, 1116, 1969, 1441, 1120, 1481, 1310, 2057, 1184, 1483, 1179, 1180,
        1995, 1487, 1192, 1188, 1991, 1187}], 
      Line3DBox[{942, 928, 1908, 927, 1329, 933, 1910, 934, 1334, 953, 1339, 
       951, 2037, 950, 1355, 975, 1922, 976, 1359, 1358, 981, 988, 1925, 1366,
        987, 992, 1927, 1368, 991, 1460, 1148, 1126, 1971, 1446, 1117, 1118, 
       1440, 2049, 1119, 1452, 1136, 1178, 1989, 1478, 1177, 1477, 1309, 2056,
        1181, 1486, 1199, 1194, 1992, 1193}], 
      Line3DBox[{1013, 1014, 1935, 1015, 1380, 1006, 1933, 1005, 1383, 1028, 
       1384, 1302, 2042, 1030, 1421, 1095, 1967, 1111, 1435, 1434, 1110, 1104,
        1963, 1431, 1103, 1080, 1956, 1409, 1079, 1493, 1210, 1211, 2003, 
       1506, 1217, 1218, 1503, 2061, 1229, 1502, 1228, 1262, 2018, 1529, 1263,
        1527, 1258, 2062, 1257, 1530, 1265, 1270, 2020, 1269}], 
      Line3DBox[{1016, 1017, 1937, 999, 1375, 1000, 1931, 1001, 1386, 1031, 
       1385, 1032, 1941, 1033, 1420, 1093, 1960, 1094, 1424, 1423, 1099, 1090,
        1959, 1416, 1073, 1074, 2044, 1407, 1075, 1497, 1216, 1207, 1998, 
       1491, 1206, 1509, 1313, 2005, 1223, 1500, 1224, 1315, 2014, 1522, 1250,
        1521, 1251, 2016, 1259, 1533, 1274, 2023, 1279, 1278}], 
      Line3DBox[{1019, 1018, 1379, 1012, 2041, 1010, 1387, 1026, 1938, 1023, 
       1381, 1022, 1425, 1098, 2048, 1096, 1436, 1108, 1965, 1432, 1106, 1438,
        1105, 1085, 1957, 1411, 1083, 1200, 1996, 1488, 1202, 1492, 1208, 
       1222, 2000, 1498, 1220, 1504, 1227, 2060, 1225, 1525, 1261, 1256, 2015,
        1523, 1254, 1531, 1316, 2063, 1267, 1273}], 
      Line3DBox[{1021, 1936, 1002, 1376, 1003, 1932, 1004, 1377, 1007, 1942, 
       1034, 1389, 1035, 1429, 1102, 1962, 1092, 1419, 1304, 2047, 1418, 1089,
        1415, 1076, 1077, 1955, 1408, 1078, 1212, 2059, 1496, 1204, 1490, 
       1205, 1230, 2002, 1505, 1231, 1508, 1232, 2027, 1264, 1528, 1252, 1314,
        2013, 1520, 1249, 1534, 2022, 1275, 1276, 1277}], 
      Line3DBox[{1036, 1037, 1038, 1944, 1390, 1042, 1394, 1050, 1947, 1049, 
       1396, 1054, 1053, 1961, 1426, 1100, 1430, 1072, 1954, 1406, 1063, 1064,
        1414, 1958, 1086, 1413, 1087, 1233, 2007, 1513, 1239, 1240, 1518, 
       2012, 1247, 1519, 1248, 1311, 1999, 1495, 1215, 1538, 1284, 2026, 1285,
        1542, 1290, 2029, 1318, 1541, 1289, 2030, 1291, 1292}], 
      Line3DBox[{1039, 1040, 1943, 1041, 1391, 1044, 1043, 1948, 1395, 1051, 
       1393, 1052, 1949, 1055, 1428, 1068, 1067, 2043, 1402, 1401, 1066, 1062,
        1951, 1399, 1061, 1088, 2046, 1417, 1091, 1510, 1234, 1238, 2006, 
       1512, 1237, 1517, 1246, 2011, 1213, 1494, 1214, 1280, 2024, 1535, 1281,
        1537, 2025, 1283, 1287, 1540, 1288, 2031, 1293, 1294}], 
      Line3DBox[{1045, 1945, 1046, 1392, 1048, 1946, 1047, 1397, 1056, 1057, 
       1950, 1398, 1058, 1427, 1101, 1964, 1069, 1403, 1070, 1404, 1071, 1953,
        1405, 1059, 1060, 1952, 1400, 1065, 1241, 1514, 2008, 1235, 1511, 
       1236, 1243, 2009, 1515, 1242, 1516, 1245, 2010, 1244, 1539, 1286, 2028,
        1317, 1536, 1282, 1543, 2032, 1297, 1295, 1296}], 
      Line3DBox[{1081, 936, 1911, 935, 1331, 941, 2035, 940, 1337, 949, 1914, 
       948, 1333, 952, 1363, 1301, 2040, 984, 1364, 980, 1924, 1357, 979, 
       1374, 998, 990, 1926, 1367, 989, 1151, 1980, 1463, 1125, 1444, 1124, 
       1114, 1968, 1439, 1112, 1113, 1442, 2050, 1121, 1480, 1183, 1186, 1990,
        1482, 1185, 1485, 1191, 2058, 1190, 1189}], 
      Line3DBox[{1271, 1272, 2021, 1268, 1532, 2019, 1266, 1255, 1524, 1253, 
       2017, 1260, 1526, 1226, 1501, 2001, 1312, 1221, 1499, 1219, 2004, 1507,
        1209, 1203, 1489, 1997, 1201, 1084, 1412, 1082, 1410, 2045, 1303, 
       1107, 1433, 1966, 1109, 1437, 1097, 1422, 1029, 1940, 1025, 1382, 1024,
        1939, 1027, 1388, 1011, 1378, 1008, 1934, 1009, 1020}]}, {
      Line3DBox[{1549, 1548, 2033, 1885, 1544, 1545, 1903, 1551, 1900, 1550}],
       Line3DBox[{1559, 1803, 1560, 1556, 1904, 1555, 1907, 1804, 1546, 1547, 
       1902, 1554, 1909, 1806, 1566, 1565, 1908, 1564, 1911, 1570}], 
      Line3DBox[{1591, 1815, 1590, 1558, 1905, 1557, 2034, 1805, 1563, 1562, 
       1906, 1561, 2038, 1810, 1567, 1568, 1910, 1569, 2035, 1807, 1571, 1572,
        1912, 1573, 1935, 1609}], 
      Line3DBox[{1624, 1622, 1828, 1623, 1946, 1621, 1620, 1948, 1829, 1625, 
       1947, 1616, 1942, 1875, 1826, 1615, 1941, 1614, 1940, 1874, 1834, 2048,
        1646, 1967, 1601, 1599, 1818, 1923, 1763, 1924, 1764, 1821, 1602, 
       1925, 1765, 1928, 1596, 1817, 1595, 1921, 1593, 1919, 1760, 1856, 1677,
        1983, 1786, 1845, 1678}], 
      Line3DBox[{1631, 1630, 1629, 1950, 1830, 1628, 1949, 1627, 1626, 1961, 
       1835, 1647, 1962, 1645, 1960, 1880, 1891, 1775, 1966, 1965, 1776, 1837,
        1650, 1963, 1604, 1929, 1767, 1822, 1603, 1926, 1766, 1927, 1589, 
       1814, 1588, 1979, 1672, 1977, 1843, 1783, 1671, 1978, 1784, 1982, 1844,
        1676, 1673, 1785}], 
      Line3DBox[{1633, 1831, 1632, 1768, 1952, 1770, 2046, 1889, 1879, 1795, 
       2007, 1717, 2059, 1898, 1713, 1790, 1998, 1791, 1855, 2004, 1718, 2000,
        1793, 1899, 2061, 1777, 1653, 1969, 1779, 1893, 2050, 1656, 1670, 
       1989, 1696, 1897, 2055, 1685, 1684, 1985, 1788, 1896, 2053, 1683, 1682,
        1986, 1686, 1846, 1687}], 
      Line3DBox[{1649, 1648, 1836, 1652, 1964, 1636, 1635, 2043, 1886, 1771, 
       1954, 1772, 2047, 1890, 1644, 1774, 1959, 1642, 2045, 1888, 1878, 1957,
        1641, 1956, 1773, 1857, 1675, 1981, 1674, 1980, 1658, 1838, 1657, 
       1971, 1781, 1972, 1840, 1660, 1669, 1975, 1663, 1973, 1841, 1664, 1665,
        1974, 1782, 1842, 1666}], 
      Line3DBox[{1651, 1638, 1832, 1637, 1953, 1634, 1951, 1769, 1833, 1958, 
       1643, 1640, 1955, 1639, 2044, 1887, 1877, 1712, 1997, 1996, 1789, 1851,
        1714, 2003, 1659, 1970, 1839, 1780, 1654, 1968, 1778, 1892, 2049, 
       1655, 1668, 1976, 1661, 1894, 2051, 1662, 1667, 1984, 1681, 1895, 2052,
        1680, 1679, 1787}], 
      Line3DBox[{1688, 1689, 1987, 1692, 1988, 1693, 1694, 2054, 1847, 1695, 
       1994, 1697, 1698, 2056, 1848, 1699, 1990, 1700, 1701, 2057, 1849, 1702,
        2018, 1737, 1720, 2060, 1853, 2001, 1794, 1719, 2005, 1722, 1854, 
       2002, 1721, 1882, 2012, 1862, 1797, 2006, 1796, 1723, 2008, 1858, 1798,
        1724}], 
      Line3DBox[{1690, 1691, 1993, 1708, 1992, 1707, 1706, 2058, 1850, 1705, 
       1995, 1710, 1711, 2062, 1865, 1799, 2015, 1735, 2017, 1734, 1864, 2014,
        1733, 1736, 2027, 1716, 1852, 1999, 1792, 1715, 2011, 1726, 1859, 
       2009, 1725, 1727, 1860, 1728}], 
      Line3DBox[{1709, 1704, 1991, 1703, 2020, 1738, 1739, 2063, 1866, 2019, 
       1740, 1883, 2016, 1732, 1863, 2013, 1731, 1884, 2026, 1746, 1867, 2024,
        1745, 1881, 2010, 1729, 1861, 1730}], 
      Line3DBox[{1741, 2021, 1742, 2023, 1744, 1743, 2022, 1800, 1869, 2029, 
       1750, 1747, 2025, 1801, 1868, 2028, 1749, 1748, 1802}], 
      Line3DBox[{1751, 2030, 1752, 2031, 1753, 1756, 2032, 1755, 1870, 1754}],
       Line3DBox[{1761, 1594, 1816, 1759, 1918, 1592, 1920, 1587, 1813, 1757, 
       1915, 1582, 1930, 1820, 1600, 1598, 1922, 1597, 2040, 1819, 1580, 1575,
        1913, 1574, 2042, 1824, 1611, 1612, 1938, 1939, 1613, 1825, 1871, 
       1931, 1605, 1932, 1606, 1827, 1944, 1617, 1618, 1943, 1619, 1945, 
       1876}], Line3DBox[{1762, 1758, 1917, 1812, 1586, 1585, 1916, 1584, 
       2039, 1811, 1583, 1553, 1901, 1552, 2037, 1809, 1579, 1578, 1914, 1577,
        2036, 1808, 1576, 1581, 1933, 1607, 2041, 1823, 1872, 1934, 1608, 
       1937, 1610, 1936, 1873}]}}},
   VertexNormals->CompressedData["
1:eJztXcGNHEcMXNgf/RzAaRdwDArALyWgEAzo7bezUBYKQ7k4EvnhNSAKBFlk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    "]],
  Axes->True,
  BoxRatios->{1, 1, 1},
  Method->{},
  PlotRange->{{-5, 5}, {0, 5}, {-14, 1}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5764965610586467`*^9}]
}, Open  ]],

Cell[TextData[{
 "Graph the parametric equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", 
     RowBox[{"s", ",", "t"}], ")"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"s", ",", "t", ",", 
      RowBox[{"s", "-", "t", "-", "4"}]}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "5"}], "\[LessEqual]", "s", "\[LessEqual]", "5"}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "5"}], TraditionalForm]]],
 ".  ",
 "This is the same set of points as in the previous two commands although the \
rendering is somewhat different."
}], "Text",
 CellChangeTimes->{{3.54447771614637*^9, 3.5444777379756184`*^9}, {
  3.5444777687903814`*^9, 3.544477821244381*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p4", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "t", ",", 
      RowBox[{"s", "-", "t", "-", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.54447761386152*^9, 3.544477697590309*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9nXl4VNX9/ycLIQESQgJhUwI4LLKLiq3bjBaVcaktKtIigoprGURFcKlC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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmXncVlMXhp999n5LokElKQ0yFg0aNWruk8qQ4auIkKGSaEAqNIlS0UhK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         "]], Polygon3DBox[CompressedData["
1:eJwtmmWgVdUWhfdea11ExEKku6VTpZQSFUQBRQQRCX2UIugTsQsQO8EAC7BR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         "]], Polygon3DBox[CompressedData["
1:eJwt2Hf8VmMbAPCn5/k97akkI6KliSZtbdFQGrS30dRQtGgQlSgNlNDAa70v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         "]]}]}, {}, {}, {}, {}}, {{}, {}, {}, {
      Line3DBox[{251, 474, 1128, 252, 1243, 488, 280, 1247, 503, 295, 1253, 
       518, 310, 1261, 533, 325, 1271, 548, 340, 1283, 563, 1177, 355, 578, 
       1192, 370, 1299, 593, 385, 1303, 608, 400, 1309, 623, 415, 1317, 638, 
       430, 1327, 653, 445, 1339, 668, 460}], 
      Line3DBox[{253, 475, 1129, 254, 489, 1141, 281, 1248, 504, 296, 1254, 
       519, 311, 1262, 534, 326, 1272, 549, 341, 1284, 564, 1178, 356, 579, 
       1193, 371, 594, 1205, 386, 1304, 609, 401, 1310, 624, 416, 1318, 639, 
       431, 1328, 654, 446, 1340, 669, 461}], 
      Line3DBox[{255, 476, 1130, 256, 490, 1142, 282, 505, 1152, 297, 1255, 
       520, 312, 1263, 535, 327, 1273, 550, 342, 1285, 565, 1179, 357, 580, 
       1194, 372, 595, 1206, 387, 610, 1216, 402, 1311, 625, 417, 1319, 640, 
       432, 1329, 655, 447, 1341, 670, 462}], 
      Line3DBox[{257, 477, 1131, 258, 491, 1143, 283, 506, 1153, 298, 521, 
       1161, 313, 1264, 536, 328, 1274, 551, 343, 1286, 566, 1180, 358, 581, 
       1195, 373, 596, 1207, 388, 611, 1217, 403, 626, 1225, 418, 1320, 641, 
       433, 1330, 656, 448, 1342, 671, 463}], 
      Line3DBox[{259, 478, 1132, 260, 492, 1144, 284, 507, 1154, 299, 522, 
       1162, 314, 537, 1168, 329, 1275, 552, 344, 1287, 567, 1181, 359, 582, 
       1196, 374, 597, 1208, 389, 612, 1218, 404, 627, 1226, 419, 642, 1232, 
       434, 1331, 657, 449, 1343, 672, 464}], 
      Line3DBox[{261, 479, 1133, 262, 493, 1145, 285, 508, 1155, 300, 523, 
       1163, 315, 538, 1169, 330, 553, 1173, 345, 1288, 568, 1182, 360, 583, 
       1197, 375, 598, 1209, 390, 613, 1219, 405, 628, 1227, 420, 643, 1233, 
       435, 658, 1237, 450, 1344, 673, 465}], 
      Line3DBox[{263, 480, 1134, 265, 494, 1146, 286, 509, 1156, 301, 524, 
       1164, 316, 539, 1170, 331, 554, 1174, 346, 569, 1183, 1184, 361, 584, 
       1198, 376, 599, 1210, 391, 614, 1220, 406, 629, 1228, 421, 644, 1234, 
       436, 659, 1238, 451, 674, 1240, 466}], 
      Line3DBox[{267, 482, 1135, 268, 1245, 496, 288, 1250, 511, 303, 1257, 
       526, 318, 1266, 541, 333, 1277, 556, 348, 1290, 571, 1186, 363, 586, 
       1199, 378, 1301, 601, 393, 1306, 616, 408, 1313, 631, 423, 1322, 646, 
       438, 1333, 661, 453, 1346, 676, 468}], 
      Line3DBox[{269, 483, 1136, 270, 497, 1147, 289, 1251, 512, 304, 1258, 
       527, 319, 1267, 542, 334, 1278, 557, 349, 1291, 572, 1187, 364, 587, 
       1200, 379, 602, 1211, 394, 1307, 617, 409, 1314, 632, 424, 1323, 647, 
       439, 1334, 662, 454, 1347, 677, 469}], 
      Line3DBox[{271, 484, 1137, 272, 498, 1148, 290, 513, 1157, 305, 1259, 
       528, 320, 1268, 543, 335, 1279, 558, 350, 1292, 573, 1188, 365, 588, 
       1201, 380, 603, 1212, 395, 618, 1221, 410, 1315, 633, 425, 1324, 648, 
       440, 1335, 663, 455, 1348, 678, 470}], 
      Line3DBox[{273, 485, 1138, 274, 499, 1149, 291, 514, 1158, 306, 529, 
       1165, 321, 1269, 544, 336, 1280, 559, 351, 1293, 574, 1189, 366, 589, 
       1202, 381, 604, 1213, 396, 619, 1222, 411, 634, 1229, 426, 1325, 649, 
       441, 1336, 664, 456, 1349, 679, 471}], 
      Line3DBox[{275, 486, 1139, 276, 500, 1150, 292, 515, 1159, 307, 530, 
       1166, 322, 545, 1171, 337, 1281, 560, 352, 1294, 575, 1190, 367, 590, 
       1203, 382, 605, 1214, 397, 620, 1223, 412, 635, 1230, 427, 650, 1235, 
       442, 1337, 665, 457, 1350, 680, 472}], 
      Line3DBox[{277, 682, 683, 1140, 278, 501, 1151, 293, 516, 1160, 308, 
       531, 1167, 323, 546, 1172, 338, 561, 1175, 353, 1295, 576, 1191, 368, 
       591, 1204, 383, 606, 1215, 398, 621, 1224, 413, 636, 1231, 428, 651, 
       1236, 443, 666, 1239, 458, 1351, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1338, 444, 652, 1326, 429, 637, 1316, 414, 
       622, 1308, 399, 607, 1302, 384, 592, 1298, 369, 577, 1296, 354, 1176, 
       562, 1282, 339, 547, 1270, 324, 532, 1260, 309, 517, 1252, 294, 502, 
       1246, 279, 487, 1242, 250, 473, 1352, 681, 688}], 
      Line3DBox[{467, 675, 1345, 452, 660, 1332, 437, 645, 1321, 422, 630, 
       1312, 407, 615, 1305, 392, 600, 1300, 377, 585, 1297, 362, 1185, 570, 
       1289, 347, 555, 1276, 332, 540, 1265, 317, 525, 1256, 302, 510, 1249, 
       287, 495, 1244, 266, 481, 1241, 264}]}, {
      Line3DBox[{690, 1010, 1015, 1352, 689, 1128, 912, 691, 1129, 913, 692, 
       1130, 914, 693, 1131, 915, 694, 1132, 916, 695, 1133, 917, 696, 1134, 
       1016, 1241, 697, 1135, 918, 698, 1136, 919, 699, 1137, 920, 700, 1138, 
       921, 701, 1139, 922, 702, 1125, 1140, 923, 1011}], 
      Line3DBox[{704, 1017, 1242, 703, 1018, 1243, 705, 1141, 924, 706, 1142, 
       925, 707, 1143, 926, 708, 1144, 927, 709, 1145, 928, 710, 1146, 1019, 
       1244, 711, 1020, 1245, 712, 1147, 929, 713, 1148, 930, 714, 1149, 931, 
       715, 1150, 932, 716, 1151, 933, 717}], 
      Line3DBox[{719, 1021, 1246, 718, 1022, 1247, 720, 1023, 1248, 721, 1152,
        934, 722, 1153, 935, 723, 1154, 936, 724, 1155, 937, 725, 1156, 1024, 
       1249, 726, 1025, 1250, 727, 1026, 1251, 728, 1157, 938, 729, 1158, 939,
        730, 1159, 940, 731, 1160, 941, 732}], 
      Line3DBox[{734, 1027, 1252, 733, 1028, 1253, 735, 1029, 1254, 736, 1030,
        1255, 737, 1161, 942, 738, 1162, 943, 739, 1163, 944, 740, 1164, 1031,
        1256, 741, 1032, 1257, 742, 1033, 1258, 743, 1034, 1259, 744, 1165, 
       945, 745, 1166, 946, 746, 1167, 947, 747}], 
      Line3DBox[{749, 1035, 1260, 748, 1036, 1261, 750, 1037, 1262, 751, 1038,
        1263, 752, 1039, 1264, 753, 1168, 948, 754, 1169, 949, 755, 1170, 
       1040, 1265, 756, 1041, 1266, 757, 1042, 1267, 758, 1043, 1268, 759, 
       1044, 1269, 760, 1171, 950, 761, 1172, 951, 762}], 
      Line3DBox[{764, 1045, 1270, 763, 1046, 1271, 765, 1047, 1272, 766, 1048,
        1273, 767, 1049, 1274, 768, 1050, 1275, 769, 1173, 952, 770, 1174, 
       1051, 1276, 771, 1052, 1277, 772, 1053, 1278, 773, 1054, 1279, 774, 
       1055, 1280, 775, 1056, 1281, 776, 1175, 953, 777}], 
      Line3DBox[{781, 1176, 954, 779, 1177, 955, 783, 1178, 956, 785, 1179, 
       957, 787, 1180, 958, 789, 1181, 959, 791, 1182, 960, 793, 1184, 1185, 
       961, 795, 1186, 962, 797, 1187, 963, 799, 1188, 964, 801, 1189, 965, 
       803, 1190, 966, 805, 1191, 967, 807}], 
      Line3DBox[{806, 1295, 1070, 804, 1294, 1069, 802, 1293, 1068, 800, 1292,
        1067, 798, 1291, 1066, 796, 1290, 1065, 794, 1289, 1064, 1183, 792, 
       1288, 1063, 790, 1287, 1062, 788, 1286, 1061, 786, 1285, 1060, 784, 
       1284, 1059, 782, 1283, 1058, 778, 1282, 1057, 780}], 
      Line3DBox[{809, 1071, 1296, 808, 1192, 968, 810, 1193, 969, 811, 1194, 
       970, 812, 1195, 971, 813, 1196, 972, 814, 1197, 973, 815, 1198, 1072, 
       1297, 816, 1199, 974, 817, 1200, 975, 818, 1201, 976, 819, 1202, 977, 
       820, 1203, 978, 821, 1204, 979, 822}], 
      Line3DBox[{824, 1073, 1298, 823, 1074, 1299, 825, 1205, 980, 826, 1206, 
       981, 827, 1207, 982, 828, 1208, 983, 829, 1209, 984, 830, 1210, 1075, 
       1300, 831, 1076, 1301, 832, 1211, 985, 833, 1212, 986, 834, 1213, 987, 
       835, 1214, 988, 836, 1215, 989, 837}], 
      Line3DBox[{839, 1077, 1302, 838, 1078, 1303, 840, 1079, 1304, 841, 1216,
        990, 842, 1217, 991, 843, 1218, 992, 844, 1219, 993, 845, 1220, 1080, 
       1305, 846, 1081, 1306, 847, 1082, 1307, 848, 1221, 994, 849, 1222, 995,
        850, 1223, 996, 851, 1224, 997, 852}], 
      Line3DBox[{854, 1083, 1308, 853, 1084, 1309, 855, 1085, 1310, 856, 1086,
        1311, 857, 1225, 998, 858, 1226, 999, 859, 1227, 1000, 860, 1228, 
       1087, 1312, 861, 1088, 1313, 862, 1089, 1314, 863, 1090, 1315, 864, 
       1229, 1001, 865, 1230, 1002, 866, 1231, 1003, 867}], 
      Line3DBox[{869, 1091, 1316, 868, 1092, 1317, 870, 1093, 1318, 871, 1094,
        1319, 872, 1095, 1320, 873, 1232, 1004, 874, 1233, 1005, 875, 1234, 
       1096, 1321, 876, 1097, 1322, 877, 1098, 1323, 878, 1099, 1324, 879, 
       1100, 1325, 880, 1235, 1006, 881, 1236, 1007, 882}], 
      Line3DBox[{884, 1101, 1326, 883, 1102, 1327, 885, 1103, 1328, 886, 1104,
        1329, 887, 1105, 1330, 888, 1106, 1331, 889, 1237, 1008, 890, 1238, 
       1107, 1332, 891, 1108, 1333, 892, 1109, 1334, 893, 1110, 1335, 894, 
       1111, 1336, 895, 1112, 1337, 896, 1239, 1009, 897}], 
      Line3DBox[{911, 1014, 1351, 1127, 910, 1350, 1124, 909, 1349, 1123, 908,
        1348, 1122, 907, 1347, 1121, 906, 1346, 1120, 905, 1345, 1119, 1240, 
       904, 1344, 1118, 903, 1343, 1117, 902, 1342, 1116, 901, 1341, 1115, 
       900, 1340, 1114, 899, 1339, 1113, 898, 1126, 1338, 1012, 1013}]}}},
   VertexNormals->CompressedData["
1:eJztyLENQFAABcAXYgyFGQzwK4naCBK12ha2MIZdTEKhsoHkqkuum9dpqZKM
TVI/tv0+HNt1vpaP3nvvvffee++9995777333nvvvffee++9995777333nvv
vffee++9995777333nvvvffee++9995777333nvvvffee++9995777333nvv
f/I3uj+BVA==
    "]],
  Axes->True,
  Method->{},
  PlotRange->{{-4.999999285714286, 4.999999285714286}, {0., 
   4.9999996428571425`}, {-13.99999892857143, 0.9999989285714284}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.576496561464286*^9}]
}, Open  ]],

Cell[TextData[{
 "Graph the parametric equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"5", "-", "t"}], ",", 
      RowBox[{"5", "-", "t"}], ",", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"2", "t"}]}]}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "5"}], TraditionalForm]]],
 " using a thick, dashed, and purple line."
}], "Text",
 CellChangeTimes->{{3.5444772507607517`*^9, 3.5444773482463274`*^9}, {
  3.5444774877513065`*^9, 3.5444775051583023`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p5", "=", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"5", "-", "t"}], ",", 
      RowBox[{"5", "-", "t"}], ",", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"2", "t"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Dashed", ",", "Purple", ",", "Thick"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5444770824281235`*^9, 3.544477087877435*^9}, {
  3.5444771580954514`*^9, 3.5444772217660933`*^9}, {3.544477435687329*^9, 
  3.5444774748755703`*^9}, {3.544477963489517*^9, 3.544477964509576*^9}}],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {RGBColor[0.5, 0, 0.5], Thickness[Large], Dashing[{Small, Small}], 
    Line3DBox[CompressedData["
1:eJw91X0w1HkcwPFdobWcXfuLy7ERpYeJkmI8dN9PD47jQkg36S42Jjld6bmo
KIuUKY9ptSaFSKVnlLv9NYuKqA4hxF3aLg8la9k83m/m5uOPz7xm3vOZz7+f
uaJdvqEaLBZrPTMzmPlTafV1aooC9OiH9YOMtHLV6dGdkxSgiigjVds4RS9I
/DzGCKgXv3Ok9CtFnzMtm2QE1Nxx98QuJUUHu/6ouVtJASpPSuV0KSha8/xv
PEZAOTbNc+g6ivZwujWfEdD0fUGeMdkU3RTj6MsIaDF7bx7LgaJP3rG8cMaG
AlQr1G258S8Cmtsnsn/1VAAo1VIVcTnFgC4Krrs9K1QAqK9csm1RDZ/ujOKZ
dKsNAI36vCri3Dse/Ula8KY3zQDQ8oOS8BJvfTo9xDDxuJUBoN6pG80nL+jR
vttLKMEjPqDu0j+83Pu4dE9kjqo9gA9o4ZPDr/cG6tDL1tQkbW/kAbo1Lt3w
ReFMmtxiN4t1eIAeC5pxU5fSpmMyz3bmrtEHlGVtJlsr1qT7q57Lm8K/AfTN
6QsJxU0atL7WPf8juXqAmnLDiobWsOnAZI/H9k90AY1YuVirzXRK1prs0DMw
wAU0xOFtoVw+JtPNqZeZLOICuuSQ09TveWrZjpFZkb/66ACa1+FXeXi1ShYV
pPXCIJ4DaF+soYvb7EFZuSCf03FtJqBPMxa6/hvQL1u4Knsyv0EbUPjYOrRU
qpB5HnTO7eRqA/rzwzadiYAumWQ0yczWVgvQS0UlagOqQSZNjvNQhmoCCtst
c/+KLpe9ymq0vZszA1C6tjXJzq+M2PY3DCVVawA6sOTxHZ/zDcR1w9GQhnE2
oC37DdtDjLuIeLKpxM6CDWiLrk+s6JOCDFuKS1M8WYD6dL1eu+dKP7G/U9FM
a09Nm54d73Ns8AtpuVk3kuw/Ma3P5RB+d4CKdNUsj3SRjU0L4RJhQqya/NS8
bpvCdnTasA0HHO0ujhH+gft69An1tF1UhuL46CRxWnGEFzUwPG11rXggjseG
ijjps1AXFUHXRYnsJXINKBia1WGbryToZt1ei/rNmjDo77jjq+EgQfWLqzO1
e7Qg063i+kDIAEHDy9b68bJnAty1SkvN7SdoUEHEA/ulOsAZT3G+srKHoONs
B5HNey5kzd/UdK1VQdAVO/0zFqfpgTq5cu7+0ncE1SwX7nKdpw8ck8/tORu6
CBq9JzFlWTMP6LqTGUaebwjqHu9tLX3AB9aCDr8OQSNBzQPjNuYdNQBIC+6s
Kqgh6HOFzuW0jQKIueonLxVWELRS9H61wIwCVqhZL9x4RNAWzavqDAsKaIte
QY3LI4L2FISVGFsx+zknRO2BDwnK7+01nWtNQUz6bTZbUkbQLXsHR5Y6M3di
eeBhdJ+ggyenbqzfxNwpyzxcLrxOUPN84+9OnWW6nc2zWpdigq5wa3upl8bc
v1k1+23gNYL+8PFiwrlMZj9/qFRDUkjQCGtz1Xkp01N9hz2N8gladt/qZUEx
01tNFRXCiwT1qraLr3zC9Jee4r8DJQQNClO5uNcyvfrIPG1JFkH3cUuVtfVM
v9ci8jbKIGiWl1NwQxPTTRfJ5MIzBO1+DS7/vGM6J2FCT5JIUPUhDWXoB6YP
dzsHGIkJyjWpLPrYw/RLqyNfCaMJumyr27dfvjD90ET/NqP9BF3H1qnfp2J6
4Z6mPmEEQQOu1MSp1UynG6WWc7YQNMz1jHM089+YF8mxDYn6Ho3+/z/Cf8x0
U+Q=
     "]]}},
  Axes->True,
  Method->{},
  PlotRange->{{0., 4.999999897959183}, {0., 
   4.999999897959183}, {-4.9999997959183675`, 4.999999795918367}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.576496561916729*^9}]
}, Open  ]],

Cell["Graph the previous graphs together.", "Text",
 CellChangeTimes->{{3.5444794808593063`*^9, 3.544479497878279*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "p5"}], "]"}]], "Input",
 CellChangeTimes->{{3.544478200145053*^9, 3.544478217266032*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {5.25, 0., 0.}], 
    {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
     {Dashing[{Small, Small}], Line3DBox[{{-5, 0, 0}, {0, 0, 0}}]}, 
     {RGBColor[
       NCache[
        Rational[2, 3], 0.6666666666666666], 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
      Text3DBox["\<\"y\"\>", {0., 5.25, 0.}], 
      {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
       {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
       {RGBColor[0, 1, 0], Dashing[{}], 
        Text3DBox["\<\"z\"\>", {0., 0., 5.25}], 
        {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
         {Dashing[{Small, Small}], Line3DBox[{{0, 0, -5}, {0, 0, 0}}]}, 
         {GrayLevel[0], Dashing[{Small, Small}], 
          Line3DBox[{{1, 0, 0}, {1, 2, 0}, {1, 2, 3}}], 
          {PointSize[Medium], Point3DBox[{1, 2, 3}], 
           {Dashing[{}], 
            Text3DBox["\<\"a\"\>", {1.1, 2.2, 3.3000000000000003`}], 
            {RGBColor[0, 0, 1], Arrow3DBox[{{1, -5, -2}, {1, -1, -2}}]}, 
            {RGBColor[1, 0, 1], Thickness[Large], 
             Line3DBox[{{-5, 5, 5}, {5, -5, 4}}], 
             {RGBColor[0.6, 0.4, 0.2], Opacity[0.6], 
              Polygon3DBox[{{0, 0, 0}, {0, 0, 4}, {0, 5, 4}, {0, 5, 0}}], 
              {PointSize[Large], Point3DBox[{4, 0, 0}]}}}}}}}}}}}}, 
   GraphicsComplex3DBox[CompressedData["
1:eJx9nXeYVNX9/2cLyy6wy7JLR2kOXYoYMVFxRoPKWGKCiiaIoGINg4VmiYL0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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmWnAV0Mbxs+cmSdCJakoJEVppV0qtBJZylqIUKHFVvZ9TYu1bBFaSEVE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          "]], Polygon3DBox[CompressedData["
1:eJwtmnXgVEUXhndm9oeIjaKA0mAQIja2YHeLDYod2IXdhZ1YYCsWYIGJgWJ3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          "]], Polygon3DBox[CompressedData["
1:eJwt2HfcjXUfB/DjnPuQmRAqpKzMlJm9yc4uq8yGkayGURml0FChgZLW03oe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          "]]}]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0rsrhWEcwPGX485xSVaykIFRBkYZmCQDGxkYKBkYDWKz8RewktgVm/v9
fkuS2+J+jc9Thu/7+b2dp87v6Zzitp7G7oQoiob0qjA/6lIziVGUy3kWcY0V
PGUNH9jAb7YyKxZFcXWZyzjAKo6wjuNs5iQ7OMc+LvKF13zXlp51ryULbXOZ
O1zhLle5F3biPtd5wA0ecpNbOjJv85g7POEuT7nHM+7znFPuccMPXYSdwh01
ardNDnKBvZxlOyfYxDHWcpiV7GcpS9RpTmcLP31HPe9YzWOWh3uxkE/OXfFN
OeE9nFWBHbOZzzjzmBXOMJNxZjCT6UxjqtLMyWFmjCnhN2Yyf5Wkn/CZvmSN
aNrj9v//8AfXm0sB
        "]]}, {
       Line3DBox[{690, 1010, 1015, 1352, 689, 1128, 912, 691, 1129, 913, 692, 
        1130, 914, 693, 1131, 915, 694, 1132, 916, 695, 1133, 917, 696, 1134, 
        1016, 1241, 697, 1135, 918, 698, 1136, 919, 699, 1137, 920, 700, 1138,
         921, 701, 1139, 922, 702, 1125, 1140, 923, 1011}], 
       Line3DBox[{704, 1017, 1242, 703, 1018, 1243, 705, 1141, 924, 706, 1142,
         925, 707, 1143, 926, 708, 1144, 927, 709, 1145, 928, 710, 1146, 1019,
         1244, 711, 1020, 1245, 712, 1147, 929, 713, 1148, 930, 714, 1149, 
        931, 715, 1150, 932, 716, 1151, 933, 717}], 
       Line3DBox[{719, 1021, 1246, 718, 1022, 1247, 720, 1023, 1248, 721, 
        1152, 934, 722, 1153, 935, 723, 1154, 936, 724, 1155, 937, 725, 1156, 
        1024, 1249, 726, 1025, 1250, 727, 1026, 1251, 728, 1157, 938, 729, 
        1158, 939, 730, 1159, 940, 731, 1160, 941, 732}], 
       Line3DBox[{734, 1027, 1252, 733, 1028, 1253, 735, 1029, 1254, 736, 
        1030, 1255, 737, 1161, 942, 738, 1162, 943, 739, 1163, 944, 740, 1164,
         1031, 1256, 741, 1032, 1257, 742, 1033, 1258, 743, 1034, 1259, 744, 
        1165, 945, 745, 1166, 946, 746, 1167, 947, 747}], 
       Line3DBox[{749, 1035, 1260, 748, 1036, 1261, 750, 1037, 1262, 751, 
        1038, 1263, 752, 1039, 1264, 753, 1168, 948, 754, 1169, 949, 755, 
        1170, 1040, 1265, 756, 1041, 1266, 757, 1042, 1267, 758, 1043, 1268, 
        759, 1044, 1269, 760, 1171, 950, 761, 1172, 951, 762}], 
       Line3DBox[{764, 1045, 1270, 763, 1046, 1271, 765, 1047, 1272, 766, 
        1048, 1273, 767, 1049, 1274, 768, 1050, 1275, 769, 1173, 952, 770, 
        1174, 1051, 1276, 771, 1052, 1277, 772, 1053, 1278, 773, 1054, 1279, 
        774, 1055, 1280, 775, 1056, 1281, 776, 1175, 953, 777}], 
       Line3DBox[{781, 1176, 954, 779, 1177, 955, 783, 1178, 956, 785, 1179, 
        957, 787, 1180, 958, 789, 1181, 959, 791, 1182, 960, 793, 1184, 1185, 
        961, 795, 1186, 962, 797, 1187, 963, 799, 1188, 964, 801, 1189, 965, 
        803, 1190, 966, 805, 1191, 967, 807}], 
       Line3DBox[{806, 1295, 1070, 804, 1294, 1069, 802, 1293, 1068, 800, 
        1292, 1067, 798, 1291, 1066, 796, 1290, 1065, 794, 1289, 1064, 1183, 
        792, 1288, 1063, 790, 1287, 1062, 788, 1286, 1061, 786, 1285, 1060, 
        784, 1284, 1059, 782, 1283, 1058, 778, 1282, 1057, 780}], 
       Line3DBox[{809, 1071, 1296, 808, 1192, 968, 810, 1193, 969, 811, 1194, 
        970, 812, 1195, 971, 813, 1196, 972, 814, 1197, 973, 815, 1198, 1072, 
        1297, 816, 1199, 974, 817, 1200, 975, 818, 1201, 976, 819, 1202, 977, 
        820, 1203, 978, 821, 1204, 979, 822}], 
       Line3DBox[{824, 1073, 1298, 823, 1074, 1299, 825, 1205, 980, 826, 1206,
         981, 827, 1207, 982, 828, 1208, 983, 829, 1209, 984, 830, 1210, 1075,
         1300, 831, 1076, 1301, 832, 1211, 985, 833, 1212, 986, 834, 1213, 
        987, 835, 1214, 988, 836, 1215, 989, 837}], 
       Line3DBox[{839, 1077, 1302, 838, 1078, 1303, 840, 1079, 1304, 841, 
        1216, 990, 842, 1217, 991, 843, 1218, 992, 844, 1219, 993, 845, 1220, 
        1080, 1305, 846, 1081, 1306, 847, 1082, 1307, 848, 1221, 994, 849, 
        1222, 995, 850, 1223, 996, 851, 1224, 997, 852}], 
       Line3DBox[{854, 1083, 1308, 853, 1084, 1309, 855, 1085, 1310, 856, 
        1086, 1311, 857, 1225, 998, 858, 1226, 999, 859, 1227, 1000, 860, 
        1228, 1087, 1312, 861, 1088, 1313, 862, 1089, 1314, 863, 1090, 1315, 
        864, 1229, 1001, 865, 1230, 1002, 866, 1231, 1003, 867}], 
       Line3DBox[{869, 1091, 1316, 868, 1092, 1317, 870, 1093, 1318, 871, 
        1094, 1319, 872, 1095, 1320, 873, 1232, 1004, 874, 1233, 1005, 875, 
        1234, 1096, 1321, 876, 1097, 1322, 877, 1098, 1323, 878, 1099, 1324, 
        879, 1100, 1325, 880, 1235, 1006, 881, 1236, 1007, 882}], 
       Line3DBox[{884, 1101, 1326, 883, 1102, 1327, 885, 1103, 1328, 886, 
        1104, 1329, 887, 1105, 1330, 888, 1106, 1331, 889, 1237, 1008, 890, 
        1238, 1107, 1332, 891, 1108, 1333, 892, 1109, 1334, 893, 1110, 1335, 
        894, 1111, 1336, 895, 1112, 1337, 896, 1239, 1009, 897}], 
       Line3DBox[{911, 1014, 1351, 1127, 910, 1350, 1124, 909, 1349, 1123, 
        908, 1348, 1122, 907, 1347, 1121, 906, 1346, 1120, 905, 1345, 1119, 
        1240, 904, 1344, 1118, 903, 1343, 1117, 902, 1342, 1116, 901, 1341, 
        1115, 900, 1340, 1114, 899, 1339, 1113, 898, 1126, 1338, 1012, 
        1013}]}, {
       Line3DBox[{251, 474, 1128, 252, 1243, 488, 280, 1247, 503, 295, 1253, 
        518, 310, 1261, 533, 325, 1271, 548, 340, 1283, 563, 1177, 355, 578, 
        1192, 370, 1299, 593, 385, 1303, 608, 400, 1309, 623, 415, 1317, 638, 
        430, 1327, 653, 445, 1339, 668, 460}], 
       Line3DBox[{253, 475, 1129, 254, 489, 1141, 281, 1248, 504, 296, 1254, 
        519, 311, 1262, 534, 326, 1272, 549, 341, 1284, 564, 1178, 356, 579, 
        1193, 371, 594, 1205, 386, 1304, 609, 401, 1310, 624, 416, 1318, 639, 
        431, 1328, 654, 446, 1340, 669, 461}], 
       Line3DBox[{255, 476, 1130, 256, 490, 1142, 282, 505, 1152, 297, 1255, 
        520, 312, 1263, 535, 327, 1273, 550, 342, 1285, 565, 1179, 357, 580, 
        1194, 372, 595, 1206, 387, 610, 1216, 402, 1311, 625, 417, 1319, 640, 
        432, 1329, 655, 447, 1341, 670, 462}], 
       Line3DBox[{257, 477, 1131, 258, 491, 1143, 283, 506, 1153, 298, 521, 
        1161, 313, 1264, 536, 328, 1274, 551, 343, 1286, 566, 1180, 358, 581, 
        1195, 373, 596, 1207, 388, 611, 1217, 403, 626, 1225, 418, 1320, 641, 
        433, 1330, 656, 448, 1342, 671, 463}], 
       Line3DBox[{259, 478, 1132, 260, 492, 1144, 284, 507, 1154, 299, 522, 
        1162, 314, 537, 1168, 329, 1275, 552, 344, 1287, 567, 1181, 359, 582, 
        1196, 374, 597, 1208, 389, 612, 1218, 404, 627, 1226, 419, 642, 1232, 
        434, 1331, 657, 449, 1343, 672, 464}], 
       Line3DBox[{261, 479, 1133, 262, 493, 1145, 285, 508, 1155, 300, 523, 
        1163, 315, 538, 1169, 330, 553, 1173, 345, 1288, 568, 1182, 360, 583, 
        1197, 375, 598, 1209, 390, 613, 1219, 405, 628, 1227, 420, 643, 1233, 
        435, 658, 1237, 450, 1344, 673, 465}], 
       Line3DBox[{263, 480, 1134, 265, 494, 1146, 286, 509, 1156, 301, 524, 
        1164, 316, 539, 1170, 331, 554, 1174, 346, 569, 1183, 1184, 361, 584, 
        1198, 376, 599, 1210, 391, 614, 1220, 406, 629, 1228, 421, 644, 1234, 
        436, 659, 1238, 451, 674, 1240, 466}], 
       Line3DBox[{267, 482, 1135, 268, 1245, 496, 288, 1250, 511, 303, 1257, 
        526, 318, 1266, 541, 333, 1277, 556, 348, 1290, 571, 1186, 363, 586, 
        1199, 378, 1301, 601, 393, 1306, 616, 408, 1313, 631, 423, 1322, 646, 
        438, 1333, 661, 453, 1346, 676, 468}], 
       Line3DBox[{269, 483, 1136, 270, 497, 1147, 289, 1251, 512, 304, 1258, 
        527, 319, 1267, 542, 334, 1278, 557, 349, 1291, 572, 1187, 364, 587, 
        1200, 379, 602, 1211, 394, 1307, 617, 409, 1314, 632, 424, 1323, 647, 
        439, 1334, 662, 454, 1347, 677, 469}], 
       Line3DBox[{271, 484, 1137, 272, 498, 1148, 290, 513, 1157, 305, 1259, 
        528, 320, 1268, 543, 335, 1279, 558, 350, 1292, 573, 1188, 365, 588, 
        1201, 380, 603, 1212, 395, 618, 1221, 410, 1315, 633, 425, 1324, 648, 
        440, 1335, 663, 455, 1348, 678, 470}], 
       Line3DBox[{273, 485, 1138, 274, 499, 1149, 291, 514, 1158, 306, 529, 
        1165, 321, 1269, 544, 336, 1280, 559, 351, 1293, 574, 1189, 366, 589, 
        1202, 381, 604, 1213, 396, 619, 1222, 411, 634, 1229, 426, 1325, 649, 
        441, 1336, 664, 456, 1349, 679, 471}], 
       Line3DBox[{275, 486, 1139, 276, 500, 1150, 292, 515, 1159, 307, 530, 
        1166, 322, 545, 1171, 337, 1281, 560, 352, 1294, 575, 1190, 367, 590, 
        1203, 382, 605, 1214, 397, 620, 1223, 412, 635, 1230, 427, 650, 1235, 
        442, 1337, 665, 457, 1350, 680, 472}], 
       Line3DBox[{277, 682, 683, 1140, 278, 501, 1151, 293, 516, 1160, 308, 
        531, 1167, 323, 546, 1172, 338, 561, 1175, 353, 1295, 576, 1191, 368, 
        591, 1204, 383, 606, 1215, 398, 621, 1224, 413, 636, 1231, 428, 651, 
        1236, 443, 666, 1239, 458, 1351, 685, 686, 687}], 
       Line3DBox[{459, 667, 684, 1338, 444, 652, 1326, 429, 637, 1316, 414, 
        622, 1308, 399, 607, 1302, 384, 592, 1298, 369, 577, 1296, 354, 1176, 
        562, 1282, 339, 547, 1270, 324, 532, 1260, 309, 517, 1252, 294, 502, 
        1246, 279, 487, 1242, 250, 473, 1352, 681, 688}], 
       Line3DBox[{467, 675, 1345, 452, 660, 1332, 437, 645, 1321, 422, 630, 
        1312, 407, 615, 1305, 392, 600, 1300, 377, 585, 1297, 362, 1185, 570, 
        1289, 347, 555, 1276, 332, 540, 1265, 317, 525, 1256, 302, 510, 1249, 
        287, 495, 1244, 266, 481, 1241, 264}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJztyLENQFAABcAXYgyFGQzwK4naCBK12ha2MIZdTEKhsoHkqkuum9dpqZKM
TVI/tv0+HNt1vpaP3nvvvffee++9995777333nvvvffee++9995777333nvv
vffee++9995777333nvvvffee++9995777333nvvvffee++9995777333nvv
f/I3uj+BVA==
     "]], {{}, {}, 
    {RGBColor[0.5, 0, 0.5], Thickness[Large], Dashing[{Small, Small}], 
     Line3DBox[CompressedData["
1:eJw91X0w1HkcwPFdobWcXfuLy7ERpYeJkmI8dN9PD47jQkg36S42Jjld6bmo
KIuUKY9ptSaFSKVnlLv9NYuKqA4hxF3aLg8la9k83m/m5uOPz7xm3vOZz7+f
uaJdvqEaLBZrPTMzmPlTafV1aooC9OiH9YOMtHLV6dGdkxSgiigjVds4RS9I
/DzGCKgXv3Ok9CtFnzMtm2QE1Nxx98QuJUUHu/6ouVtJASpPSuV0KSha8/xv
PEZAOTbNc+g6ivZwujWfEdD0fUGeMdkU3RTj6MsIaDF7bx7LgaJP3rG8cMaG
AlQr1G258S8Cmtsnsn/1VAAo1VIVcTnFgC4Krrs9K1QAqK9csm1RDZ/ujOKZ
dKsNAI36vCri3Dse/Ula8KY3zQDQ8oOS8BJvfTo9xDDxuJUBoN6pG80nL+jR
vttLKMEjPqDu0j+83Pu4dE9kjqo9gA9o4ZPDr/cG6tDL1tQkbW/kAbo1Lt3w
ReFMmtxiN4t1eIAeC5pxU5fSpmMyz3bmrtEHlGVtJlsr1qT7q57Lm8K/AfTN
6QsJxU0atL7WPf8juXqAmnLDiobWsOnAZI/H9k90AY1YuVirzXRK1prs0DMw
wAU0xOFtoVw+JtPNqZeZLOICuuSQ09TveWrZjpFZkb/66ACa1+FXeXi1ShYV
pPXCIJ4DaF+soYvb7EFZuSCf03FtJqBPMxa6/hvQL1u4Knsyv0EbUPjYOrRU
qpB5HnTO7eRqA/rzwzadiYAumWQ0yczWVgvQS0UlagOqQSZNjvNQhmoCCtst
c/+KLpe9ymq0vZszA1C6tjXJzq+M2PY3DCVVawA6sOTxHZ/zDcR1w9GQhnE2
oC37DdtDjLuIeLKpxM6CDWiLrk+s6JOCDFuKS1M8WYD6dL1eu+dKP7G/U9FM
a09Nm54d73Ns8AtpuVk3kuw/Ma3P5RB+d4CKdNUsj3SRjU0L4RJhQqya/NS8
bpvCdnTasA0HHO0ujhH+gft69An1tF1UhuL46CRxWnGEFzUwPG11rXggjseG
ijjps1AXFUHXRYnsJXINKBia1WGbryToZt1ei/rNmjDo77jjq+EgQfWLqzO1
e7Qg063i+kDIAEHDy9b68bJnAty1SkvN7SdoUEHEA/ulOsAZT3G+srKHoONs
B5HNey5kzd/UdK1VQdAVO/0zFqfpgTq5cu7+0ncE1SwX7nKdpw8ck8/tORu6
CBq9JzFlWTMP6LqTGUaebwjqHu9tLX3AB9aCDr8OQSNBzQPjNuYdNQBIC+6s
Kqgh6HOFzuW0jQKIueonLxVWELRS9H61wIwCVqhZL9x4RNAWzavqDAsKaIte
QY3LI4L2FISVGFsx+zknRO2BDwnK7+01nWtNQUz6bTZbUkbQLXsHR5Y6M3di
eeBhdJ+ggyenbqzfxNwpyzxcLrxOUPN84+9OnWW6nc2zWpdigq5wa3upl8bc
v1k1+23gNYL+8PFiwrlMZj9/qFRDUkjQCGtz1Xkp01N9hz2N8gladt/qZUEx
01tNFRXCiwT1qraLr3zC9Jee4r8DJQQNClO5uNcyvfrIPG1JFkH3cUuVtfVM
v9ci8jbKIGiWl1NwQxPTTRfJ5MIzBO1+DS7/vGM6J2FCT5JIUPUhDWXoB6YP
dzsHGIkJyjWpLPrYw/RLqyNfCaMJumyr27dfvjD90ET/NqP9BF3H1qnfp2J6
4Z6mPmEEQQOu1MSp1UynG6WWc7YQNMz1jHM089+YF8mxDYn6Ho3+/z/Cf8x0
U+Q=
      "]]}}},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{
  3.5764965623067665`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 1", "Subsection",
 CellChangeTimes->{{3.5444779003209047`*^9, 3.544477904931168*^9}}],

Cell[TextData[{
 "[8 points] Graph the planes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", "y"}], "+", "z"}], "=", "4"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"4", "x"}], "+", 
     RowBox[{"2", "y"}], "+", 
     RowBox[{"3", "z"}]}], "=", "12"}], TraditionalForm]]],
 " and their intersection in the nonnegative orthant.  Also include normal \
vectors for each plane that share the same base point."
}], "Text",
 CellChangeTimes->{{3.5444789946314955`*^9, 3.5444790112434454`*^9}, {
   3.5444791052518225`*^9, 3.544479156072729*^9}, 3.5444799075057087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2", "Subsection",
 CellChangeTimes->{{3.544479191497755*^9, 3.544479193603876*^9}}],

Cell[TextData[{
 "[6 points] Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["l", "1"], TraditionalForm]]],
 " be the line passing through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"1", ",", "2", ",", "3"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"3", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 ".  Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["l", "2"], TraditionalForm]]],
 " be the line passing through the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"11", ",", "2", ",", 
     RowBox[{"-", "7"}]}], "\[RightAngleBracket]"}], TraditionalForm]]],
 " in the direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"1", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}], TraditionalForm]]],
 ".  Graph these two lines in a manner that shows where they intersect or in \
a manner that shows that they do not intersect."
}], "Text",
 CellChangeTimes->{{3.5444791993522043`*^9, 3.544479268979187*^9}, {
   3.54447936781284*^9, 3.544479379262495*^9}, 3.5444798521135406`*^9, 
   3.5444799440007963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3", "Subsection",
 CellChangeTimes->{{3.544479275640568*^9, 3.54447927742167*^9}}],

Cell[TextData[{
 "[6 points] Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["l", "1"], TraditionalForm]]],
 " be the line passing through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"1", ",", "2", ",", "3"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"3", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 ".  Let ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " be the plane described by the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"3", "x"}], "+", "y", "+", "z"}], "=", "7"}], TraditionalForm]]],
 ".  Graph this line and plane in a manner that shows where they intersect or \
in a manner that shows that they do not intersect."
}], "Text",
 CellChangeTimes->{{3.5444793322798076`*^9, 3.5444793626085424`*^9}, {
   3.544479395247409*^9, 3.5444793956534324`*^9}, 3.5444798559247584`*^9, 
   3.544479950921192*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4", "Subsection",
 CellChangeTimes->{{3.544479439865961*^9, 3.54447944282213*^9}}],

Cell["\<\
[9 points] Graph two different types of quadric surfaces together in an \
aesthetically pleasing manner.  At minimum, the two surfaces should intersect \
each other and be different colors that do not have 100% opacity.  State the \
names of the two quadric surface (e.g., the green surface is an ellipsoid and \
the blue surface is a hyperboloid of one sheet). \
\>", "Text",
 CellChangeTimes->{{3.5444794484784536`*^9, 3.544479452163665*^9}, {
  3.5444795464990606`*^9, 3.544479780262431*^9}, {3.544479879835126*^9, 
  3.544479880443161*^9}, {3.5444826053950195`*^9, 3.5444826058060427`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{707, 545},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 178, 2, 79, "Section"],
Cell[760, 26, 206, 4, 49, "Text"],
Cell[CellGroupData[{
Cell[991, 34, 178, 6, 44, "Subsection"],
Cell[1172, 42, 226, 5, 30, "Text"],
Cell[1401, 49, 2658, 73, 192, "Input"],
Cell[4062, 124, 694, 10, 106, "Text"],
Cell[CellGroupData[{
Cell[4781, 138, 3989, 86, 172, "Input"],
Cell[8773, 226, 1482, 29, 420, "Output"]
}, Open  ]],
Cell[10270, 258, 686, 23, 30, "Text"],
Cell[CellGroupData[{
Cell[10981, 285, 417, 11, 31, "Input"],
Cell[11401, 298, 39019, 631, 311, "Output"]
}, Open  ]],
Cell[50435, 932, 834, 24, 68, "Text"],
Cell[CellGroupData[{
Cell[51294, 960, 597, 16, 31, "Input"],
Cell[51894, 978, 66354, 1069, 413, "Output"]
}, Open  ]],
Cell[118263, 2050, 869, 28, 68, "Text"],
Cell[CellGroupData[{
Cell[119157, 2082, 434, 12, 31, "Input"],
Cell[119594, 2096, 38612, 622, 447, "Output"]
}, Open  ]],
Cell[158221, 2721, 716, 22, 49, "Text"],
Cell[CellGroupData[{
Cell[158962, 2747, 714, 19, 52, "Input"],
Cell[159679, 2768, 2201, 43, 447, "Output"]
}, Open  ]],
Cell[161895, 2814, 119, 1, 30, "Text"],
Cell[CellGroupData[{
Cell[162039, 2819, 159, 3, 31, "Input"],
Cell[162201, 2824, 51269, 835, 447, 42219, 685, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213519, 3665, 100, 1, 43, "Subsection"],
Cell[213622, 3668, 652, 19, 68, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214311, 3692, 98, 1, 43, "Subsection"],
Cell[214412, 3695, 1280, 39, 87, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215729, 3739, 97, 1, 43, "Subsection"],
Cell[215829, 3742, 1037, 32, 68, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216903, 3779, 97, 1, 43, "Subsection"],
Cell[217003, 3782, 604, 9, 87, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
